/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.common.model.GenericResponse;
import com.urbanairship.api.nameduser.model.NamedUserScopedPayload;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class NamedUserScopedRequest
implements Request<GenericResponse> {
    private final ObjectMapper MAPPER = ChannelObjectMapper.getInstance();
    private static final String API_CHANNELS_ATTRIBUTES = "/api/named_users/scoped/";
    private final String path;
    private final NamedUserScopedPayload payload;

    private NamedUserScopedRequest(String path, String namedUserId, NamedUserScopedPayload payload) {
        this.path = path + namedUserId;
        this.payload = payload;
    }

    public static NamedUserScopedRequest newRequest(String namedUserId, NamedUserScopedPayload payload) {
        return new NamedUserScopedRequest(API_CHANNELS_ATTRIBUTES, namedUserId, payload);
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        return this.payload.toJSON();
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<GenericResponse> getResponseParser() {
        return response -> (GenericResponse)this.MAPPER.readValue(response, GenericResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

