/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.customevents.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.customevents.model.CustomEventChannelType;
import java.util.Optional;

public class CustomEventUser {
    private final Optional<CustomEventChannelType> channelType;
    private final Optional<String> channel;
    private final Optional<String> namedUserId;

    private CustomEventUser(Builder builder) {
        this.channelType = Optional.ofNullable(builder.channelType);
        this.channel = Optional.ofNullable(builder.channel);
        this.namedUserId = Optional.ofNullable(builder.namedUserId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<CustomEventChannelType> getChannelType() {
        return this.channelType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomEventUser that = (CustomEventUser)o;
        return this.channelType == that.channelType && Objects.equal(this.channel, that.channel);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.channelType, this.channel});
    }

    public Optional<String> getChannel() {
        return this.channel;
    }

    public Optional<String> getNamedUserId() {
        return this.namedUserId;
    }

    public static class Builder {
        private String channel;
        private CustomEventChannelType channelType;
        private String namedUserId;

        public Builder setChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public Builder setNamedUserId(String namedUserId) {
            this.namedUserId = namedUserId;
            return this;
        }

        public Builder setCustomEventChannelType(CustomEventChannelType channelType) {
            this.channelType = channelType;
            return this;
        }

        public CustomEventUser build() {
            Preconditions.checkArgument((this.channelType != null && this.channel != null || this.namedUserId != null ? 1 : 0) != 0, (Object)"Must provide channel and channelType, or namedUserId");
            Preconditions.checkArgument((this.channelType == null || this.channel == null || this.namedUserId == null ? 1 : 0) != 0, (Object)"Must provide either channel and channelType or namedUserId, not both");
            return new CustomEventUser(this);
        }
    }
}

