/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.urbanairship.api.client.ClientException;
import com.urbanairship.api.client.RequestError;
import com.urbanairship.api.client.Response;
import com.urbanairship.api.client.ResponseCallback;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.client.ServerException;
import io.netty.handler.codec.http.HttpHeaders;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResponseAsyncHandler<T>
implements AsyncHandler<Response> {
    private static final Logger log = LoggerFactory.getLogger(ResponseAsyncHandler.class);
    private static final String CONTENT_TYPE_KEY = "Content-type";
    private final Response.Builder<T> responseBuilder = new Response.Builder();
    private final ClientException.Builder exceptionBuilder = ClientException.newBuilder();
    private final ServerException.Builder serverExceptionBuilder = ServerException.newBuilder();
    private final Optional<ResponseCallback> clientCallback;
    private final ResponseParser<T> parser;
    private final StringBuilder bodyBuilder = new StringBuilder();
    private AtomicInteger retryCount = new AtomicInteger(0);
    private String exceptionContentType;
    private boolean isSuccessful;
    private Integer statusCode;

    public ResponseAsyncHandler(Optional<ResponseCallback> clientCallback, ResponseParser<T> parser) {
        this.clientCallback = clientCallback;
        this.parser = parser;
    }

    public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        this.statusCode = responseStatus.getStatusCode();
        if (this.statusCode == 401 || this.statusCode == 403) {
            this.exceptionBuilder.setStatusCode(this.statusCode);
            this.exceptionBuilder.setStatusText(responseStatus.getStatusText());
            this.isSuccessful = false;
        } else {
            this.responseBuilder.setStatus(responseStatus.getStatusCode());
            this.isSuccessful = true;
        }
        return AsyncHandler.State.CONTINUE;
    }

    public AsyncHandler.State onHeadersReceived(HttpHeaders httpHeaders) throws Exception {
        if (this.isSuccessful) {
            this.responseBuilder.setHeaders(this.getHeaders(httpHeaders));
        } else {
            this.exceptionContentType = httpHeaders.get(CONTENT_TYPE_KEY);
        }
        return AsyncHandler.State.CONTINUE;
    }

    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        String body = new String(bodyPart.getBodyPartBytes(), StandardCharsets.UTF_8);
        if (!this.isSuccessful) {
            RequestError error = RequestError.errorFromResponse(body, this.exceptionContentType);
            this.exceptionBuilder.setRequestError(error);
            throw this.exceptionBuilder.build();
        }
        this.bodyBuilder.append(body);
        return AsyncHandler.State.CONTINUE;
    }

    public Response onCompleted() throws Exception {
        if (StringUtils.isNotBlank((String)this.bodyBuilder.toString())) {
            try {
                this.responseBuilder.setBody(this.parser.parse(this.bodyBuilder.toString()));
            }
            catch (JsonParseException e) {
                log.debug(String.format("Could not parse the response: %s", this.bodyBuilder.toString()), (Throwable)e);
                this.onThrowable(e);
                return this.responseBuilder.build();
            }
        }
        Response response = this.responseBuilder.build();
        if (this.clientCallback.isPresent()) {
            this.clientCallback.get().completed(response);
        }
        log.debug("Response processing completed for " + response.getBody());
        return response;
    }

    public void onThrowable(Throwable t) {
        log.error("Exception thrown during response processing", t);
        if (this.clientCallback.isPresent()) {
            this.clientCallback.get().error(t);
        }
    }

    private Map<String, String> getHeaders(HttpHeaders httpResponse) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry entry : httpResponse.entries()) {
            headers.put((String)entry.getKey(), (String)entry.getValue());
        }
        return headers;
    }

    public int getRetryCount() {
        return this.retryCount.get();
    }

    public void incrementRetryCount() {
        this.retryCount.incrementAndGet();
    }
}

