/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.templates.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.templates.model.PartialPushPayload;
import com.urbanairship.api.templates.model.TemplateVariable;
import java.util.List;
import org.joda.time.DateTime;

public class TemplateView {
    private final String id;
    private final DateTime createdAt;
    private final DateTime modifiedAt;
    private final DateTime lastUsed;
    private final String name;
    private final Optional<String> description;
    private final ImmutableList<TemplateVariable> variables;
    private final Optional<PartialPushPayload> partialPushPayload;

    private TemplateView(Builder builder) {
        this.id = builder.id;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.lastUsed = builder.lastUsed;
        this.name = builder.name;
        this.description = Optional.fromNullable((Object)builder.description);
        this.variables = builder.variables.build();
        this.partialPushPayload = Optional.fromNullable((Object)builder.partialPushPayload);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public DateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public DateTime getLastUsed() {
        return this.lastUsed;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public ImmutableList<TemplateVariable> getVariables() {
        return this.variables;
    }

    public Optional<PartialPushPayload> getPartialPushPayload() {
        return this.partialPushPayload;
    }

    public String toString() {
        return "TemplateView{id='" + this.id + '\'' + ", createdAt=" + this.createdAt + ", modifiedAt=" + this.modifiedAt + ", lastUsed=" + this.lastUsed + ", name=" + this.name + ", description=" + this.description + ", variables=" + this.variables + ", partialPushPayload=" + this.partialPushPayload + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateView that = (TemplateView)o;
        if (!this.createdAt.equals((Object)that.createdAt)) {
            return false;
        }
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.lastUsed.equals((Object)that.lastUsed)) {
            return false;
        }
        if (!this.modifiedAt.equals((Object)that.modifiedAt)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.partialPushPayload.equals(that.partialPushPayload)) {
            return false;
        }
        return this.variables.equals(that.variables);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.createdAt.hashCode();
        result = 31 * result + this.modifiedAt.hashCode();
        result = 31 * result + this.lastUsed.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.variables.hashCode();
        result = 31 * result + this.partialPushPayload.hashCode();
        return result;
    }

    public static final class Builder {
        private String id = null;
        private DateTime createdAt = null;
        private DateTime modifiedAt = null;
        private DateTime lastUsed = null;
        private String name = null;
        private String description = null;
        private ImmutableList.Builder<TemplateVariable> variables = ImmutableList.builder();
        private PartialPushPayload partialPushPayload = null;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setCreatedAt(DateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder setModifiedAt(DateTime modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder setLastUsed(DateTime lastUsed) {
            this.lastUsed = lastUsed;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder addVariable(TemplateVariable variable) {
            this.variables.add((Object)variable);
            return this;
        }

        public Builder addAllVariables(List<TemplateVariable> variables) {
            this.variables.addAll(variables);
            return this;
        }

        public Builder setPushPayload(PartialPushPayload partialPushPayload) {
            this.partialPushPayload = partialPushPayload;
            return this;
        }

        public TemplateView build() {
            return new TemplateView(this);
        }
    }
}

