/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.templates;

import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.templates.model.TemplatePushPayload;
import com.urbanairship.api.templates.model.TemplateResponse;
import com.urbanairship.api.templates.parse.TemplatesObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class TemplatePushRequest
implements Request<TemplateResponse> {
    private static final String TEMPLATE_PUSH = "/api/templates/push/";
    private static final String TEMPLATE_PUSH_VALIDATE = "/api/templates/push/validate/";
    private List<TemplatePushPayload> templatePushPayloads = new ArrayList<TemplatePushPayload>();
    private boolean validateOnly = false;

    private TemplatePushRequest() {
    }

    public static TemplatePushRequest newRequest() {
        return new TemplatePushRequest();
    }

    public TemplatePushRequest addTemplatePushPayload(TemplatePushPayload templatePushPayload) {
        this.templatePushPayloads.add(templatePushPayload);
        return this;
    }

    public TemplatePushRequest addAllTemplatePushPayloads(List<TemplatePushPayload> templatePushPayloads) {
        this.templatePushPayloads.addAll(templatePushPayloads);
        return this;
    }

    public TemplatePushRequest setValidateOnly(boolean validateOnly) {
        this.validateOnly = validateOnly;
        return this;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        try {
            if (this.templatePushPayloads.size() == 1) {
                return TemplatesObjectMapper.getInstance().writeValueAsString((Object)this.templatePushPayloads.get(0));
            }
            return TemplatesObjectMapper.getInstance().writeValueAsString(this.templatePushPayloads);
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getClass().getName() + "\", \"message\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        String path = this.validateOnly ? TEMPLATE_PUSH_VALIDATE : TEMPLATE_PUSH;
        return RequestUtils.resolveURI(baseUri, path);
    }

    @Override
    public ResponseParser<TemplateResponse> getResponseParser() {
        return new ResponseParser<TemplateResponse>(){

            @Override
            public TemplateResponse parse(String response) throws IOException {
                return (TemplateResponse)TemplatesObjectMapper.getInstance().readValue(response, TemplateResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return false;
    }
}

