/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.tags;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.opencsv.CSVWriter;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;

public class TagListErrorsRequest
implements Request<String> {
    private static final String TAG_LIST_PATH = "/api/tag-lists/";
    private final String path;
    private Optional<FileOutputStream> fileOutputStream = Optional.absent();

    private TagListErrorsRequest(String name) {
        this.path = TAG_LIST_PATH + name + "/errors";
    }

    public static TagListErrorsRequest newRequest(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)name), (Object)"List name cannot be empty.");
        return new TagListErrorsRequest(name);
    }

    public TagListErrorsRequest setOutputStream(FileOutputStream fileOutputStream) {
        this.fileOutputStream = Optional.of((Object)fileOutputStream);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+csv; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<String> getResponseParser() {
        return new ResponseParser<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String parse(String response) throws IOException {
                if (TagListErrorsRequest.this.fileOutputStream.isPresent()) {
                    try (OutputStreamWriter stream = new OutputStreamWriter((OutputStream)TagListErrorsRequest.this.fileOutputStream.get());
                         CSVWriter writer = new CSVWriter((Writer)stream, ',', '\u0000', '\u0000', "\n");){
                        String[] rows;
                        for (String row : rows = response.split("\n")) {
                            writer.writeNext(row.split(","));
                        }
                    }
                    finally {
                        ((FileOutputStream)TagListErrorsRequest.this.fileOutputStream.get()).close();
                    }
                }
                return response;
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

