/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.sms.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.sms.model.SmsModelObject;

public class CustomSmsResponseSmsPayload
extends SmsModelObject {
    private final String mobileOriginatedId;
    private final String alert;
    private final Optional<Boolean> shortenLinks;

    protected CustomSmsResponseSmsPayload(Builder builder) {
        this.mobileOriginatedId = builder.mobileOriginatedId;
        this.alert = builder.alert;
        this.shortenLinks = Optional.fromNullable((Object)builder.shortenLinks);
    }

    public String getMobileOriginatedId() {
        return this.mobileOriginatedId;
    }

    public String getAlert() {
        return this.alert;
    }

    public Optional<Boolean> getShortenLinks() {
        return this.shortenLinks;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomSmsResponseSmsPayload that = (CustomSmsResponseSmsPayload)o;
        return this.mobileOriginatedId == that.mobileOriginatedId && Objects.equal((Object)this.alert, (Object)that.alert) && Objects.equal(this.shortenLinks, that.shortenLinks);
    }

    public String toString() {
        return "CustomSmsResponseSmsPayload{mobileOriginatedId=" + this.mobileOriginatedId + ", alert=" + this.alert + ", shortenLinks=" + this.shortenLinks + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mobileOriginatedId, this.alert, this.shortenLinks});
    }

    public static final class Builder {
        private String mobileOriginatedId;
        private String alert;
        private boolean shortenLinks;

        protected Builder() {
        }

        public Builder setMobileOriginatedId(String mobileOriginatedId) {
            this.mobileOriginatedId = mobileOriginatedId;
            return this;
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder setShortenLinks(boolean shortenLinks) {
            this.shortenLinks = shortenLinks;
            return this;
        }

        public CustomSmsResponseSmsPayload build() {
            Preconditions.checkNotNull((Object)this.mobileOriginatedId, (Object)"mobileOriginatedId cannot be null.");
            Preconditions.checkNotNull((Object)this.alert, (Object)"alert cannot be null.");
            return new CustomSmsResponseSmsPayload(this);
        }
    }
}

