/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.schedule.model.SchedulePayload;
import com.urbanairship.api.schedule.model.ScheduleResponse;
import com.urbanairship.api.schedule.parse.ScheduleObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;

public class ScheduleRequest
implements Request<ScheduleResponse> {
    static final String API_SCHEDULE_PATH = "/api/schedules/";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final List<SchedulePayload> schedulePayloads = new ArrayList<SchedulePayload>();
    private final String path;
    private final Request.HttpMethod method;

    private ScheduleRequest(SchedulePayload schedulePayload, Request.HttpMethod method, String path) {
        this.schedulePayloads.add(schedulePayload);
        this.path = path;
        this.method = method;
    }

    private ScheduleRequest(List<SchedulePayload> schedulePayloads, Request.HttpMethod method, String path) {
        Preconditions.checkNotNull(schedulePayloads, (Object)"Schedule pushes required when creating a schedule request.");
        if (schedulePayloads.isEmpty()) {
            throw new IllegalStateException("Schedule payloads cannot be empty.");
        }
        this.path = path;
        this.method = method;
        this.schedulePayloads.addAll(schedulePayloads);
    }

    public static ScheduleRequest newRequest(SchedulePayload schedulePayload) {
        Preconditions.checkNotNull((Object)schedulePayload, (Object)"Schedule Push may not be null");
        return new ScheduleRequest(schedulePayload, Request.HttpMethod.POST, API_SCHEDULE_PATH);
    }

    public static ScheduleRequest newRequest(List<SchedulePayload> schedulePayloads) {
        return new ScheduleRequest(schedulePayloads, Request.HttpMethod.POST, API_SCHEDULE_PATH);
    }

    public static ScheduleRequest newUpdateRequest(SchedulePayload schedulePayload, String scheduleId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)scheduleId), (Object)"Schedule ID may not be mull");
        Preconditions.checkNotNull((Object)schedulePayload, (Object)"Schedule Push may not be null");
        return new ScheduleRequest(schedulePayload, Request.HttpMethod.PUT, API_SCHEDULE_PATH + scheduleId);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return this.method;
    }

    @Override
    public String getRequestBody() {
        if (this.schedulePayloads.size() == 1) {
            return this.schedulePayloads.get(0).toJSON();
        }
        ArrayNode arrayNode = MAPPER.createArrayNode();
        for (SchedulePayload schedulePayload : this.schedulePayloads) {
            try {
                JsonNode pushJson = MAPPER.readTree(schedulePayload.toJSON());
                arrayNode.add(pushJson);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return arrayNode.toString();
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<ScheduleResponse> getResponseParser() {
        return new ResponseParser<ScheduleResponse>(){

            @Override
            public ScheduleResponse parse(String response) throws IOException {
                return (ScheduleResponse)ScheduleObjectMapper.getInstance().readValue(response, ScheduleResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return false;
    }
}

