/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.common.model.ErrorDetails;
import com.urbanairship.api.reports.model.PlatformStats;

public class PlatformStatsResponse {
    private final Optional<String> nextPage;
    private final Optional<ImmutableList<PlatformStats>> platformStatsObjects;
    private final boolean ok;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private PlatformStatsResponse() {
        this(null, null, null, null, null);
    }

    private PlatformStatsResponse(Optional<String> nextPage, Optional<ImmutableList<PlatformStats>> platformStatsObjects, Boolean ok, Optional<String> error, Optional<ErrorDetails> errorDetails) {
        this.nextPage = nextPage;
        this.platformStatsObjects = platformStatsObjects;
        this.ok = ok;
        this.error = error;
        this.errorDetails = errorDetails;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getNextPage() {
        return this.nextPage;
    }

    public Optional<ImmutableList<PlatformStats>> getPlatformStatsObjects() {
        return this.platformStatsObjects;
    }

    public boolean getOk() {
        return this.ok;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "PlatformStatsResponse{nextPage=" + this.nextPage + ", platformStatsObjects=" + this.platformStatsObjects + ", ok=" + this.ok + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nextPage, this.platformStatsObjects, this.ok, this.error, this.errorDetails});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlatformStatsResponse other = (PlatformStatsResponse)obj;
        return Objects.equal(this.platformStatsObjects, other.platformStatsObjects) && Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal(this.error, other.error) && Objects.equal(this.errorDetails, other.errorDetails);
    }

    public static class Builder {
        private String nextPage = null;
        private ImmutableList.Builder<PlatformStats> platformStatsObjects = ImmutableList.builder();
        private boolean ok;
        private String error;
        private ErrorDetails errorDetails;

        private Builder() {
        }

        public Builder setNextPage(String value) {
            this.nextPage = value;
            return this;
        }

        public Builder addPlatformStatsObject(PlatformStats value) {
            this.platformStatsObjects.add((Object)value);
            return this;
        }

        public Builder addPlatformStatsObjects(Iterable<? extends PlatformStats> value) {
            this.platformStatsObjects.addAll(value);
            return this;
        }

        public Builder setOk(boolean value) {
            this.ok = value;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public PlatformStatsResponse build() {
            return new PlatformStatsResponse(Optional.fromNullable((Object)this.nextPage), Optional.fromNullable((Object)this.platformStatsObjects.build()), this.ok, Optional.fromNullable((Object)this.error), Optional.fromNullable((Object)this.errorDetails));
        }
    }
}

