/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.android;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.urbanairship.api.push.model.notification.android.InboxStyle;
import com.urbanairship.api.push.model.notification.android.Style;
import java.io.IOException;

public class InboxStyleSerializer
extends JsonSerializer<InboxStyle> {
    public void serialize(InboxStyle style, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStringField("type", Style.Type.INBOX.getStyleType());
        jgen.writeArrayFieldStart("lines");
        for (String value : style.getContent()) {
            jgen.writeString(value);
        }
        jgen.writeEndArray();
        if (style.getTitle().isPresent()) {
            jgen.writeStringField("title", (String)style.getTitle().get());
        }
        if (style.getSummary().isPresent()) {
            jgen.writeStringField("summary", (String)style.getSummary().get());
        }
    }

    public void serializeWithType(InboxStyle style, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSerializer) throws IOException {
        typeSerializer.writeTypePrefixForObject((Object)style, jgen);
        this.serialize(style, jgen, provider);
        typeSerializer.writeTypeSuffixForObject((Object)style, jgen);
    }
}

