/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.common.parse.FieldParser;
import com.urbanairship.api.common.parse.FieldParserRegistry;
import com.urbanairship.api.common.parse.MapFieldParserRegistry;
import com.urbanairship.api.common.parse.StandardObjectDeserializer;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.Notification;
import com.urbanairship.api.push.parse.notification.NotificationReader;
import java.io.IOException;
import java.util.Map;

public class NotificationDeserializer
extends JsonDeserializer<Notification> {
    private static final FieldParserRegistry<Notification, NotificationReader> FIELD_PARSERS = new MapFieldParserRegistry<Notification, NotificationReader>((Map<String, FieldParser<NotificationReader>>)ImmutableMap.builder().put((Object)"alert", (Object)new FieldParser<NotificationReader>(){

        @Override
        public void parse(NotificationReader reader, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            reader.readAlert(jsonParser);
        }
    }).put((Object)"wns", (Object)new FieldParser<NotificationReader>(){

        @Override
        public void parse(NotificationReader reader, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            reader.readPlatformDevicePayloadOverride(DeviceType.WNS, jsonParser, deserializationContext);
        }
    }).put((Object)"ios", (Object)new FieldParser<NotificationReader>(){

        @Override
        public void parse(NotificationReader reader, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            reader.readPlatformDevicePayloadOverride(DeviceType.IOS, jsonParser, deserializationContext);
        }
    }).put((Object)"android", (Object)new FieldParser<NotificationReader>(){

        @Override
        public void parse(NotificationReader reader, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            reader.readPlatformDevicePayloadOverride(DeviceType.ANDROID, jsonParser, deserializationContext);
        }
    }).put((Object)"amazon", (Object)new FieldParser<NotificationReader>(){

        @Override
        public void parse(NotificationReader reader, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            reader.readPlatformDevicePayloadOverride(DeviceType.AMAZON, jsonParser, deserializationContext);
        }
    }).put((Object)"sms", (Object)new FieldParser<NotificationReader>(){

        @Override
        public void parse(NotificationReader reader, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            reader.readPlatformDevicePayloadOverride(DeviceType.SMS, jsonParser, deserializationContext);
        }
    }).put((Object)"web", (Object)new FieldParser<NotificationReader>(){

        @Override
        public void parse(NotificationReader reader, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            reader.readPlatformDevicePayloadOverride(DeviceType.WEB, jsonParser, deserializationContext);
        }
    }).put((Object)"email", (Object)new FieldParser<NotificationReader>(){

        @Override
        public void parse(NotificationReader reader, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            reader.readPlatformDevicePayloadOverride(DeviceType.EMAIL, jsonParser, deserializationContext);
        }
    }).put((Object)"actions", (Object)new FieldParser<NotificationReader>(){

        @Override
        public void parse(NotificationReader reader, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            reader.readActions(jsonParser);
        }
    }).put((Object)"interactive", (Object)new FieldParser<NotificationReader>(){

        @Override
        public void parse(NotificationReader reader, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            reader.readInteractive(jsonParser);
        }
    }).build());
    private final StandardObjectDeserializer<Notification, ?> deserializer;

    public NotificationDeserializer(final Map<DeviceType, JsonDeserializer<? extends DevicePayloadOverride>> payloadOverridesDeserializersRegistry) {
        this.deserializer = new StandardObjectDeserializer<Notification, NotificationReader>(FIELD_PARSERS, new Supplier<NotificationReader>(){

            public NotificationReader get() {
                return new NotificationReader(payloadOverridesDeserializersRegistry);
            }
        });
    }

    public Notification deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        return this.deserializer.deserialize(parser, deserializationContext);
    }
}

