/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.audience;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.FieldParser;
import com.urbanairship.api.common.parse.FieldParserRegistry;
import com.urbanairship.api.common.parse.MapFieldParserRegistry;
import com.urbanairship.api.common.parse.StandardObjectDeserializer;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.push.model.audience.SelectorType;
import com.urbanairship.api.push.model.audience.Selectors;
import com.urbanairship.api.push.parse.audience.SelectorReader;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class SelectorDeserializer
extends JsonDeserializer<Selector> {
    private static final FieldParserRegistry<Selector, SelectorReader> FIELD_PARSERS = new MapFieldParserRegistry<Selector, SelectorReader>(SelectorDeserializer.getRegistryMap(), (reader, parser, context) -> reader.readExtraField(parser));
    public static final SelectorDeserializer INSTANCE = new SelectorDeserializer();
    private final StandardObjectDeserializer<Selector, ?> deserializer = new StandardObjectDeserializer<Selector, SelectorReader>(FIELD_PARSERS, () -> new SelectorReader());

    public Selector deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.VALUE_STRING) {
            return this.readAtomicSelector(parser);
        }
        return this.deserializer.deserialize(parser, context);
    }

    private Selector readAtomicSelector(JsonParser parser) throws IOException {
        String value = parser.getText();
        SelectorType type = SelectorType.getSelectorTypeFromIdentifier(value);
        if (type != null) {
            return Selectors.atomic(type);
        }
        throw new APIParsingException(String.format("Unknown atomic selector '%s'", value));
    }

    private static Map<String, FieldParser<SelectorReader>> getRegistryMap() {
        ImmutableMap registryMap = ImmutableMap.builder().put((Object)"tag", (reader, parser, context) -> reader.readValueSelector(SelectorType.TAG, parser, context)).put((Object)"alias", (reader, parser, context) -> reader.readValueSelector(SelectorType.ALIAS, parser, context)).put((Object)"named_user", (reader, parser, context) -> reader.readValueSelector(SelectorType.NAMED_USER, parser, context)).put((Object)"segment", (reader, parser, context) -> reader.readValueSelector(SelectorType.SEGMENT, parser, context)).put((Object)"static_list", (reader, parser, context) -> reader.readValueSelector(SelectorType.STATIC_LIST, parser, context)).put((Object)"attribute", (reader, parser, context) -> reader.readValueSelector(SelectorType.ATTRIBUTE, parser, context)).put((Object)"subscription_list", (reader, parser, context) -> reader.readValueSelector(SelectorType.SUBSCRIPTION_LIST, parser, context)).put((Object)"device_token", (reader, parser, context) -> reader.readValueSelector(SelectorType.DEVICE_TOKEN, parser, context)).put((Object)"apid", (reader, parser, context) -> reader.readValueSelector(SelectorType.APID, parser, context)).put((Object)"wns", (reader, parser, context) -> reader.readValueSelector(SelectorType.WNS, parser, context)).put((Object)"ios_channel", (reader, parser, context) -> reader.readValueSelector(SelectorType.IOS_CHANNEL, parser, context)).put((Object)"amazon_channel", (reader, parser, context) -> reader.readValueSelector(SelectorType.AMAZON_CHANNEL, parser, context)).put((Object)"android_channel", (reader, parser, context) -> reader.readValueSelector(SelectorType.ANDROID_CHANNEL, parser, context)).put((Object)"channel", (reader, parser, context) -> reader.readValueSelector(SelectorType.CHANNEL, parser, context)).put((Object)"and", (reader, parser, context) -> reader.readCompoundSelector(SelectorType.AND, parser, context)).put((Object)"or", (reader, parser, context) -> reader.readCompoundSelector(SelectorType.OR, parser, context)).put((Object)"not", (reader, parser, context) -> reader.readCompoundSelector(SelectorType.NOT, parser, context)).put((Object)"location", (reader, parser, context) -> reader.readLocationSelector(parser)).build();
        TreeMap<String, FieldParser<SelectorReader>> caseInsensitiveRegistryMap = new TreeMap<String, FieldParser<SelectorReader>>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveRegistryMap.putAll((Map<String, FieldParser<SelectorReader>>)registryMap);
        return caseInsensitiveRegistryMap;
    }
}

