/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.web;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.notification.actions.Actions;

public class Button {
    private final Optional<Actions> actions;
    private final String id;
    private final String label;

    private Button(Builder builder) {
        this.actions = Optional.fromNullable((Object)builder.actions);
        this.id = builder.id;
        this.label = builder.label;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<Actions> getActions() {
        return this.actions;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Button button = (Button)o;
        return Objects.equal(this.actions, button.actions) && Objects.equal((Object)this.id, (Object)button.id) && Objects.equal((Object)this.label, (Object)button.label);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.actions, this.id, this.label});
    }

    public static class Builder {
        private Actions actions = null;
        private String id = null;
        private String label = null;

        public Builder setActions(Actions actions) {
            this.actions = actions;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Button build() {
            Preconditions.checkNotNull((Object)this.id, (Object)"Button id must be set");
            Preconditions.checkNotNull((Object)this.label, (Object)"Button label must be set.");
            return new Button(this);
        }
    }
}

