/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.sms;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;

public class SmsPayload
extends PushModelObject
implements DevicePayloadOverride {
    private Optional<String> alert;
    private Optional<PushExpiry> expiry;

    private SmsPayload(Builder builder) {
        this.alert = Optional.fromNullable((Object)builder.alert);
        this.expiry = Optional.fromNullable((Object)builder.expiry);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.SMS;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert;
    }

    public Optional<PushExpiry> getExpiry() {
        return this.expiry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsPayload that = (SmsPayload)o;
        return Objects.equal(this.alert, that.alert) && Objects.equal(this.expiry, that.expiry);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.alert, this.expiry});
    }

    public static class Builder {
        private String alert;
        private PushExpiry expiry;

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder setExpiry(PushExpiry expiry) {
            this.expiry = expiry;
            return this;
        }

        public SmsPayload build() {
            return new SmsPayload(this);
        }
    }
}

