/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.Position;

public class Display {
    private final Optional<String> primaryColor;
    private final Optional<String> secondaryColor;
    private final Optional<Integer> duration;
    private final Optional<Position> position;

    public static Builder newBuilder() {
        return new Builder();
    }

    private Display(Builder builder) {
        this.primaryColor = Optional.fromNullable((Object)builder.primaryColor);
        this.secondaryColor = Optional.fromNullable((Object)builder.secondaryColor);
        this.duration = Optional.fromNullable((Object)builder.duration);
        this.position = Optional.fromNullable((Object)((Object)builder.position));
    }

    public Optional<String> getPrimaryColor() {
        return this.primaryColor;
    }

    public Optional<String> getSecondaryColor() {
        return this.secondaryColor;
    }

    public Optional<Integer> getDuration() {
        return this.duration;
    }

    public Optional<Position> getPosition() {
        return this.position;
    }

    public String toString() {
        return "Display{primaryColor=" + this.primaryColor + ", secondaryColor=" + this.secondaryColor + ", duration=" + this.duration + ", position=" + this.position + '}';
    }

    public static class Builder {
        private String primaryColor = null;
        private String secondaryColor = null;
        private Integer duration = null;
        private Position position = null;

        public Builder setPrimaryColor(String primaryColor) {
            this.primaryColor = primaryColor;
            return this;
        }

        public Builder setSecondaryColor(String secondaryColor) {
            this.secondaryColor = secondaryColor;
            return this;
        }

        public Builder setDuration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public Builder setPosition(Position position) {
            this.position = position;
            return this;
        }

        public Display build() {
            Preconditions.checkArgument((this.primaryColor != null || this.secondaryColor != null || this.duration != null || this.position != null ? 1 : 0) != 0, (Object)"At least one of primaryColor, secondaryColor, duration, or position must not be null.");
            return new Display(this);
        }
    }
}

