/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser;

import com.google.common.collect.ImmutableList;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.common.model.GenericResponse;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class NamedUserUninstallRequest
implements Request<GenericResponse> {
    private static final String API_NAMED_USERS_UNINSTALL_PATH = "/api/named_users/uninstall/";
    private final Map<String, ImmutableList<String>> payload = new HashMap<String, ImmutableList<String>>();

    private NamedUserUninstallRequest(ImmutableList<String> namedUsersList) {
        this.payload.put("named_user_id", namedUsersList);
    }

    public static NamedUserUninstallRequest newUninstallRequest(ImmutableList<String> namedUsersList) {
        return new NamedUserUninstallRequest(namedUsersList);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        try {
            return ChannelObjectMapper.getInstance().writeValueAsString(this.payload);
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getClass().getName() + "\", \"message\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, API_NAMED_USERS_UNINSTALL_PATH);
    }

    @Override
    public ResponseParser<GenericResponse> getResponseParser() {
        return RequestUtils.GENERIC_RESPONSE_PARSER;
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return false;
    }
}

