/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.nameduser.model.NamedUserListingResponse;
import com.urbanairship.api.nameduser.parse.NamedUserObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class NamedUserListingRequest
implements Request<NamedUserListingResponse> {
    private static final String API_NAMED_USERS_GET = "/api/named_users/";
    private final String path;

    private NamedUserListingRequest(String path) {
        this.path = path;
    }

    public static NamedUserListingRequest newRequest(String namedUserId) {
        return new NamedUserListingRequest("/api/named_users/?id=" + namedUserId);
    }

    public static NamedUserListingRequest newRequest() {
        return new NamedUserListingRequest(API_NAMED_USERS_GET);
    }

    public static NamedUserListingRequest newRequest(URI nextPage) {
        Preconditions.checkNotNull((Object)nextPage, (Object)"Next page URI cannot be null");
        return new NamedUserListingRequest(nextPage.getPath() + "?" + nextPage.getQuery());
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<NamedUserListingResponse> getResponseParser() {
        return new ResponseParser<NamedUserListingResponse>(){

            @Override
            public NamedUserListingResponse parse(String response) throws IOException {
                return (NamedUserListingResponse)NamedUserObjectMapper.getInstance().readValue(response, NamedUserListingResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

