/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.createandsend.model.notification.email;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import java.util.Objects;

public class EmailFields {
    private final String subject;
    private final String plainTextBody;
    private final Optional<String> htmlBody;

    private EmailFields(@JsonProperty(value="subject") String subject, @JsonProperty(value="plaintext_body") String plainTextBody, @JsonProperty(value="html_body") String htmlBody) {
        this.subject = subject;
        this.plainTextBody = plainTextBody;
        this.htmlBody = Optional.fromNullable((Object)htmlBody);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSubject() {
        return this.subject;
    }

    public String getPlainTextBody() {
        return this.plainTextBody;
    }

    public Optional<String> getHtmlBody() {
        return this.htmlBody;
    }

    public String toString() {
        return "EmailFields{subject=" + this.subject + ", htmlBody=" + this.htmlBody + ", plainTextBody=" + this.plainTextBody + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmailFields)) {
            return false;
        }
        EmailFields that = (EmailFields)o;
        return Objects.equals(this.getSubject(), that.getSubject()) && Objects.equals(this.getHtmlBody(), that.getHtmlBody()) && Objects.equals(this.getPlainTextBody(), that.getPlainTextBody());
    }

    public int hashCode() {
        return Objects.hash(this.getSubject(), this.getHtmlBody(), this.getPlainTextBody());
    }

    public static class Builder {
        private String subject = null;
        private String htmlBody = null;
        private String plainTextBody = null;

        private Builder() {
        }

        public Builder setSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder setHtmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
            return this;
        }

        public Builder setPlainTextBody(String plainTextBody) {
            this.plainTextBody = plainTextBody;
            return this;
        }

        public EmailFields build() {
            return new EmailFields(this.subject, this.plainTextBody, this.htmlBody);
        }
    }
}

