/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.createandsend.model.notification;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.createandsend.model.notification.CreateAndSendPayload;
import com.urbanairship.api.push.model.PushModelObject;
import java.util.Objects;
import org.joda.time.DateTime;

public class CreateAndSendSchedulePayload
extends PushModelObject {
    private final DateTime scheduleTime;
    private final CreateAndSendPayload payload;
    private final Optional<String> name;

    private CreateAndSendSchedulePayload(Builder builder) {
        this.scheduleTime = builder.scheduleTime;
        this.payload = builder.payload;
        this.name = Optional.fromNullable((Object)builder.name);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public DateTime getScheduleTime() {
        return this.scheduleTime;
    }

    public CreateAndSendPayload getPayload() {
        return this.payload;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public String toString() {
        return "CreateAndSendSchedulePayload{scheduleTime=" + this.scheduleTime + ", payload=" + this.payload + ", name=" + this.name + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateAndSendSchedulePayload)) {
            return false;
        }
        CreateAndSendSchedulePayload that = (CreateAndSendSchedulePayload)o;
        return Objects.equals(this.getScheduleTime(), that.getScheduleTime()) && Objects.equals(this.getPayload(), that.getPayload()) && Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getScheduleTime(), this.getPayload(), this.getName());
    }

    public static class Builder {
        private DateTime scheduleTime;
        private CreateAndSendPayload payload;
        private String name;

        private Builder() {
        }

        public Builder setScheduleTime(DateTime scheduleTime) {
            this.scheduleTime = scheduleTime;
            return this;
        }

        public Builder setPayload(CreateAndSendPayload payload) {
            this.payload = payload;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public CreateAndSendSchedulePayload build() {
            Preconditions.checkNotNull((Object)this.scheduleTime, (Object)"Schedule Time must be set.");
            Preconditions.checkNotNull((Object)this.payload, (Object)"Payload must be set.");
            return new CreateAndSendSchedulePayload(this);
        }
    }
}

