/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.urbanairship.api.client.RequestErrorDetails;
import com.urbanairship.api.client.parse.RequestErrorObjectMapper;
import com.urbanairship.api.common.parse.APIParsingException;
import java.io.IOException;
import java.util.Optional;

public final class RequestError {
    private static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String UA_APPLICATION_JSON = "application/vnd.urbanairship+json";
    static final String UA_APPLICATION_JSON_V3 = "application/vnd.urbanairship+json;version=3";
    private final boolean ok;
    private final com.google.common.base.Optional<String> operationId;
    private final String error;
    private final com.google.common.base.Optional<Number> errorCode;
    private final com.google.common.base.Optional<RequestErrorDetails> details;

    private RequestError(boolean ok, com.google.common.base.Optional<String> operationId, String error, com.google.common.base.Optional<Number> errorCode, com.google.common.base.Optional<RequestErrorDetails> details) {
        this.ok = ok;
        this.operationId = operationId;
        if (error == null || error.isEmpty()) {
            throw new IllegalArgumentException("Error cannot be null or empty");
        }
        this.error = error;
        this.errorCode = errorCode;
        this.details = details;
    }

    public static RequestError errorFromResponse(String body, String contentType) throws IOException {
        if ((contentType = contentType.replace(" ", "")).equalsIgnoreCase(CONTENT_TYPE_TEXT_HTML)) {
            return RequestError.nonJSONError(body);
        }
        if (contentType.equalsIgnoreCase(CONTENT_TYPE_JSON)) {
            return RequestError.nonV3JSONError(body);
        }
        if (contentType.equalsIgnoreCase(UA_APPLICATION_JSON) || contentType.equalsIgnoreCase(UA_APPLICATION_JSON_V3)) {
            try {
                ObjectMapper mapper = RequestErrorObjectMapper.getInstance();
                return (RequestError)mapper.readValue(body, RequestError.class);
            }
            catch (APIParsingException e) {
                return RequestError.nonV3JSONError(body);
            }
        }
        return RequestError.newBuilder().setError("Unknown response parsing error").build();
    }

    @Deprecated
    private static RequestError nonJSONError(String body) throws IOException {
        return RequestError.newBuilder().setError(body).build();
    }

    @Deprecated
    private static RequestError nonV3JSONError(String body) throws IOException {
        ObjectMapper mapper = RequestErrorObjectMapper.getInstance();
        JsonNode error = mapper.readTree(body);
        String errorMessage = RequestError.extractErrorMessage(error);
        return RequestError.newBuilder().setError(errorMessage).build();
    }

    private static String extractErrorMessage(JsonNode error) {
        Optional<String> topLevelMessage = RequestError.getTopLevelMessage(error);
        Optional<String> detailMessage = RequestError.getDetailMessage(error);
        Optional<String> detailArrayMessage = RequestError.getDetailArrayMessage(error);
        String errorMessage = topLevelMessage.isPresent() ? topLevelMessage.get() : (detailMessage.isPresent() ? detailMessage.get() : (detailArrayMessage.isPresent() ? detailArrayMessage.get() : "Unknown response parsing error"));
        return errorMessage;
    }

    private static Optional<String> getTopLevelMessage(JsonNode error) {
        JsonNode message = error.get("message");
        if (message != null) {
            return Optional.of(message.asText());
        }
        return Optional.empty();
    }

    private static Optional<String> getDetailMessage(JsonNode error) {
        JsonNode message;
        JsonNode details = error.get("details");
        if (details != null && !details.isArray() && (message = details.get("message")) != null) {
            return Optional.of(message.asText());
        }
        return Optional.empty();
    }

    private static Optional<String> getDetailArrayMessage(JsonNode error) {
        JsonNode detailMessage;
        JsonNode firstDetail;
        JsonNode details = error.get("details");
        if (details != null && details.isArray() && (firstDetail = details.get(0)) != null && (detailMessage = firstDetail.get("message")) != null) {
            return Optional.of(detailMessage.asText());
        }
        return Optional.empty();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public com.google.common.base.Optional<String> getOperationId() {
        return this.operationId;
    }

    public String getError() {
        return this.error;
    }

    public com.google.common.base.Optional<Number> getErrorCode() {
        return this.errorCode;
    }

    public com.google.common.base.Optional<RequestErrorDetails> getDetails() {
        return this.details;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ok:");
        stringBuilder.append(this.getOk());
        stringBuilder.append("\nRequestError:");
        stringBuilder.append(this.getError());
        if (this.errorCode.isPresent()) {
            stringBuilder.append("\nCode:");
            stringBuilder.append(this.getErrorCode());
        }
        if (this.details.isPresent()) {
            stringBuilder.append("\nDetails:");
            stringBuilder.append(((RequestErrorDetails)this.details.get()).toString());
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestError)) {
            return false;
        }
        RequestError that = (RequestError)o;
        if (this.ok != that.ok) {
            return false;
        }
        if (this.details != null ? !this.details.equals(that.details) : that.details != null) {
            return false;
        }
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        if (this.errorCode != null ? !this.errorCode.equals(that.errorCode) : that.errorCode != null) {
            return false;
        }
        return !(this.operationId != null ? !this.operationId.equals(that.operationId) : that.operationId != null);
    }

    public int hashCode() {
        int result = this.ok ? 1 : 0;
        result = 31 * result + (this.operationId != null ? this.operationId.hashCode() : 0);
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + (this.errorCode != null ? this.errorCode.hashCode() : 0);
        result = 31 * result + (this.details != null ? this.details.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private boolean ok;
        private String operationId;
        private String error;
        private Number errorCode;
        private RequestErrorDetails details;

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setOperationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorCode(Number errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder setDetails(RequestErrorDetails details) {
            this.details = details;
            return this;
        }

        public RequestError build() {
            return new RequestError(this.ok, com.google.common.base.Optional.fromNullable((Object)this.operationId), this.error, com.google.common.base.Optional.fromNullable((Object)this.errorCode), com.google.common.base.Optional.fromNullable((Object)this.details));
        }
    }
}

