/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.parse.attributes;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.urbanairship.api.channel.model.attributes.Attribute;
import com.urbanairship.api.common.parse.DateFormats;
import java.io.IOException;
import org.joda.time.ReadableInstant;

public class AttributeSerializer
extends JsonSerializer<Attribute> {
    public void serialize(Attribute attribute, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("key", attribute.getKey());
        jgen.writeStringField("action", attribute.getAction().getIdentifier());
        if (attribute.getTimeStamp().isPresent()) {
            jgen.writeStringField("timestamp", DateFormats.DATE_FORMATTER.print((ReadableInstant)attribute.getTimeStamp().get()));
        }
        if (attribute.getValue().isPresent()) {
            jgen.writeStringField("value", attribute.getValue().get());
        }
        jgen.writeEndObject();
    }
}

