/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.email;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.common.model.GenericResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.entity.ContentType;

public class EmailTagRequest
implements Request<GenericResponse> {
    private static final String EMAIL_CHANNELS_TAGS_PATH = "/api/channels/email/tags";
    private static final String AUDIENCE_KEY = "audience";
    private static final String ADD_KEY = "add";
    private static final String REMOVE_KEY = "remove";
    private static final String SET_KEY = "set";
    private static final String EMAIL_CHANNEL_KEY = "email_address";
    private final Map<String, Set<String>> addTags = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> removeTags = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> setTags = new HashMap<String, Set<String>>();
    private ObjectNode payloadNode = JsonNodeFactory.instance.objectNode();
    private ObjectNode emailNode = JsonNodeFactory.instance.objectNode();
    private StringBuilder jsonStringBuilder = new StringBuilder();

    public static EmailTagRequest newRequest() {
        return new EmailTagRequest();
    }

    public EmailTagRequest addEmailChannel(String channel) {
        this.jsonStringBuilder.append(channel);
        return this;
    }

    public EmailTagRequest addTags(String tagGroup, Set<String> tags) {
        this.addTags.put(tagGroup, tags);
        return this;
    }

    public EmailTagRequest removeTags(String tagGroup, Set<String> tags) {
        this.removeTags.put(tagGroup, tags);
        return this;
    }

    public EmailTagRequest setTags(String tagGroup, Set<String> tags) {
        this.setTags.put(tagGroup, tags);
        return this;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        this.emailNode.put(EMAIL_CHANNEL_KEY, this.jsonStringBuilder.toString());
        this.payloadNode.set(AUDIENCE_KEY, (JsonNode)this.emailNode);
        if (!this.addTags.isEmpty()) {
            this.payloadNode.putPOJO(ADD_KEY, this.addTags);
        }
        if (!this.removeTags.isEmpty()) {
            this.payloadNode.putPOJO(REMOVE_KEY, this.removeTags);
        }
        if (!this.setTags.isEmpty()) {
            this.payloadNode.putPOJO(SET_KEY, this.setTags);
        }
        Preconditions.checkArgument((this.payloadNode.has(ADD_KEY) || this.payloadNode.has(REMOVE_KEY) || this.payloadNode.has(SET_KEY) ? 1 : 0) != 0, (Object)"Audience required when executing a channel tag operation");
        if (this.payloadNode.has(SET_KEY)) {
            Preconditions.checkArgument((!this.payloadNode.has(REMOVE_KEY) && !this.payloadNode.has(ADD_KEY) ? 1 : 0) != 0);
        }
        try {
            return ChannelObjectMapper.getInstance().writeValueAsString((Object)this.payloadNode);
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getClass().getName() + "\", \"message\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, EMAIL_CHANNELS_TAGS_PATH);
    }

    @Override
    public ResponseParser<GenericResponse> getResponseParser() {
        return RequestUtils.GENERIC_RESPONSE_PARSER;
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

