/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.urbanairship.api.common.model.ErrorDetails;

public class ChannelUninstallResponse {
    private final boolean ok;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private ChannelUninstallResponse(Builder builder) {
        this.ok = builder.ok;
        this.error = Optional.fromNullable((Object)builder.error);
        this.errorDetails = Optional.fromNullable((Object)builder.errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isOk() {
        return this.ok;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "ChannelUninstallResponse{ok=" + this.ok + ", error='" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.error, this.errorDetails});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelUninstallResponse other = (ChannelUninstallResponse)obj;
        return Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal(this.error, other.error) && Objects.equal(this.errorDetails, other.errorDetails);
    }

    public static class Builder {
        boolean ok;
        String error;
        ErrorDetails errorDetails;

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public ChannelUninstallResponse build() {
            return new ChannelUninstallResponse(this);
        }
    }
}

