/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.channel.model.ChannelView;
import com.urbanairship.api.common.model.ErrorDetails;

public class ChannelResponse {
    private final boolean ok;
    private final Optional<String> nextPage;
    private final Optional<ChannelView> channelObject;
    private final Optional<ImmutableList<ChannelView>> channelObjects;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private ChannelResponse() {
        this(false, null, null, null, null, null);
    }

    private ChannelResponse(boolean ok, String nextPage, Optional<ChannelView> channelObject, Optional<ImmutableList<ChannelView>> channelObjects, String error, ErrorDetails errorDetails) {
        this.ok = ok;
        this.nextPage = Optional.fromNullable((Object)nextPage);
        this.channelObject = channelObject;
        this.channelObjects = channelObjects;
        this.error = Optional.fromNullable((Object)error);
        this.errorDetails = Optional.fromNullable((Object)errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public Optional<String> getNextPage() {
        return this.nextPage;
    }

    public Optional<ChannelView> getChannelView() {
        return this.channelObject;
    }

    public Optional<ImmutableList<ChannelView>> getChannelObjects() {
        return this.channelObjects;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "ChannelResponse{ok=" + this.ok + ", nextPage='" + this.nextPage + '\'' + ", channelObject=" + this.channelObject + ", channelObjects=" + this.channelObjects + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.nextPage, this.channelObject, this.channelObjects, this.error, this.errorDetails});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelResponse other = (ChannelResponse)obj;
        return Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal(this.nextPage, other.nextPage) && Objects.equal(this.channelObject, other.channelObject) && Objects.equal(this.channelObjects, other.channelObjects) && Objects.equal(this.error, other.error) && Objects.equal(this.errorDetails, other.errorDetails);
    }

    public static class Builder {
        private boolean ok;
        private String nextPage = null;
        private ChannelView channelObject = null;
        private ImmutableList.Builder<ChannelView> channelObjects = ImmutableList.builder();
        private String error = null;
        private ErrorDetails errorDetails = null;

        private Builder() {
        }

        public Builder setOk(boolean value) {
            this.ok = value;
            return this;
        }

        public Builder setNextPage(String value) {
            this.nextPage = value;
            return this;
        }

        public Builder setChannelObject(ChannelView value) {
            this.channelObject = value;
            return this;
        }

        public Builder addChannel(ChannelView value) {
            this.channelObjects.add((Object)value);
            return this;
        }

        public Builder addAllChannels(Iterable<? extends ChannelView> value) {
            this.channelObjects.addAll(value);
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public ChannelResponse build() {
            if (this.channelObject != null) {
                Preconditions.checkArgument((this.nextPage == null && this.channelObjects.build().isEmpty() ? 1 : 0) != 0);
            }
            return new ChannelResponse(this.ok, this.nextPage, Optional.fromNullable((Object)this.channelObject), Optional.fromNullable((Object)this.channelObjects.build()), this.error, this.errorDetails);
        }
    }
}

