/*
 * Copyright (c) 2013-2016.  Urban Airship and Contributors
 */

package com.urbanairship.api.common.parse;


import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

import java.io.IOException;

public class StringFieldDeserializer {

    public static final StringFieldDeserializer INSTANCE = new StringFieldDeserializer();

    private StringFieldDeserializer() { }

    public String deserialize(JsonParser parser, String fieldName) throws IOException {
        JsonToken token = parser.getCurrentToken();
        if (token != JsonToken.VALUE_STRING) {
            APIParsingException.raise(String.format("\"%s\" field is expected to be a string", fieldName), parser);
        }

        return parser.getText();
    }
}
