/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.templates.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TemplateResponse {
    private final boolean ok;
    private final Optional<String> operationId;
    private final Optional<String> templateId;
    private final Optional<ImmutableList<String>> pushIds;

    private TemplateResponse(Builder builder) {
        this.ok = builder.ok;
        this.operationId = Optional.fromNullable((Object)builder.operationId);
        this.templateId = Optional.fromNullable((Object)builder.templateId);
        this.pushIds = builder.pushIds.build().isEmpty() ? Optional.absent() : Optional.fromNullable((Object)builder.pushIds.build());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public Optional<String> getOperationId() {
        return this.operationId;
    }

    public Optional<String> getTemplateId() {
        return this.templateId;
    }

    public Optional<ImmutableList<String>> getPushIds() {
        return this.pushIds;
    }

    public String toString() {
        return "TemplateResponse{ok=" + this.ok + ", operationId=" + this.operationId + ", templateId=" + this.templateId + ", pushIds=" + this.pushIds + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateResponse that = (TemplateResponse)o;
        if (this.ok != that.ok) {
            return false;
        }
        if (!this.operationId.equals(that.operationId)) {
            return false;
        }
        if (!this.pushIds.equals(that.pushIds)) {
            return false;
        }
        return this.templateId.equals(that.templateId);
    }

    public int hashCode() {
        int result = this.ok ? 1 : 0;
        result = 31 * result + this.operationId.hashCode();
        result = 31 * result + this.templateId.hashCode();
        result = 31 * result + this.pushIds.hashCode();
        return result;
    }

    public static class Builder {
        private boolean ok = false;
        private String operationId = null;
        private String templateId = null;
        private ImmutableList.Builder<String> pushIds = ImmutableList.builder();

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setOperationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder setTemplateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder addPushId(String pushId) {
            this.pushIds.add((Object)pushId);
            return this;
        }

        public Builder addAllPushIds(List<String> pushIds) {
            this.pushIds.addAll(pushIds);
            return this;
        }

        public TemplateResponse build() {
            return new TemplateResponse(this);
        }
    }
}

