/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.templates.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.templates.model.TemplateView;
import java.util.List;

public class TemplateListingResponse {
    private final boolean ok;
    private final Optional<TemplateView> template;
    private final Optional<ImmutableList<TemplateView>> templates;
    private final Optional<Integer> count;
    private final Optional<Integer> totalCount;
    private final Optional<String> nextPage;
    private final Optional<String> prevPage;

    private TemplateListingResponse(Builder builder) {
        this.ok = builder.ok;
        this.template = Optional.fromNullable((Object)builder.template);
        this.templates = Optional.fromNullable((Object)builder.templates.build());
        this.count = Optional.fromNullable((Object)builder.count);
        this.totalCount = Optional.fromNullable((Object)builder.totalCount);
        this.nextPage = Optional.fromNullable((Object)builder.nextPage);
        this.prevPage = Optional.fromNullable((Object)builder.prevPage);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public Optional<TemplateView> getTemplate() {
        return this.template;
    }

    public Optional<ImmutableList<TemplateView>> getTemplates() {
        return this.templates;
    }

    public Optional<Integer> getCount() {
        return this.count;
    }

    public Optional<Integer> getTotalCount() {
        return this.totalCount;
    }

    public Optional<String> getNextPage() {
        return this.nextPage;
    }

    public Optional<String> getPrevPage() {
        return this.prevPage;
    }

    public String toString() {
        return "TemplateListingResponse{ok=" + this.ok + ", template=" + this.template + ", templates=" + this.templates + ", count=" + this.count + ", totalCount=" + this.totalCount + ", nextPage=" + this.nextPage + ", prevPage=" + this.prevPage + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateListingResponse that = (TemplateListingResponse)o;
        if (this.ok != that.ok) {
            return false;
        }
        if (!this.count.equals(that.count)) {
            return false;
        }
        if (!this.nextPage.equals(that.nextPage)) {
            return false;
        }
        if (!this.prevPage.equals(that.prevPage)) {
            return false;
        }
        if (!this.template.equals(that.template)) {
            return false;
        }
        if (!this.templates.equals(that.templates)) {
            return false;
        }
        return this.totalCount.equals(that.totalCount);
    }

    public int hashCode() {
        int result = this.ok ? 1 : 0;
        result = 31 * result + this.template.hashCode();
        result = 31 * result + this.templates.hashCode();
        result = 31 * result + this.count.hashCode();
        result = 31 * result + this.totalCount.hashCode();
        result = 31 * result + this.nextPage.hashCode();
        result = 31 * result + this.prevPage.hashCode();
        return result;
    }

    public static class Builder {
        private boolean ok;
        private TemplateView template = null;
        private ImmutableList.Builder<TemplateView> templates = ImmutableList.builder();
        private Integer count = null;
        private Integer totalCount = null;
        private String nextPage = null;
        private String prevPage = null;

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setTemplate(TemplateView template) {
            this.template = template;
            return this;
        }

        public Builder setTemplates(List<TemplateView> templates) {
            this.templates.addAll(templates);
            return this;
        }

        public Builder setCount(Integer count) {
            this.count = count;
            return this;
        }

        public Builder setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder setNextPage(String nextPage) {
            this.nextPage = nextPage;
            return this;
        }

        public Builder setPrevPage(String prevPage) {
            this.prevPage = prevPage;
            return this;
        }

        public TemplateListingResponse build() {
            if (!this.templates.build().isEmpty()) {
                Preconditions.checkArgument((this.template == null && this.count != null && this.totalCount != null ? 1 : 0) != 0);
            }
            return new TemplateListingResponse(this);
        }
    }
}

