/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.audience.Selector;

public class SegmentView {
    private final Selector criteria;
    private final String displayName;

    private SegmentView(Selector criteria, String displayName) {
        this.criteria = criteria;
        this.displayName = displayName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Selector getCriteria() {
        return this.criteria;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return "SegmentView{criteria=" + this.criteria + "display_name=" + this.displayName + "}";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.criteria, this.displayName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentView other = (SegmentView)obj;
        return Objects.equal((Object)this.displayName, (Object)other.displayName) && Objects.equal((Object)this.criteria, (Object)other.criteria);
    }

    public static final class Builder {
        private String displayName = null;
        private Selector criteria = null;

        private Builder() {
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder setCriteria(Selector criteria) {
            this.criteria = criteria;
            return this;
        }

        public SegmentView build() {
            Preconditions.checkNotNull((Object)this.criteria);
            Preconditions.checkNotNull((Object)this.displayName);
            return new SegmentView(this.criteria, this.displayName);
        }
    }
}

