/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.schedule.model.SchedulePayload;
import java.util.List;

public final class ListAllSchedulesResponse {
    private final boolean ok;
    private final int count;
    private final int totalCount;
    private final String nextPage;
    private final ImmutableList<SchedulePayload> scheduleObjects;

    private ListAllSchedulesResponse(boolean ok, int count, int totalCount, String nextPage, ImmutableList<SchedulePayload> response) {
        this.ok = ok;
        this.count = count;
        this.totalCount = totalCount;
        this.nextPage = nextPage;
        this.scheduleObjects = response;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public int getCount() {
        return this.count;
    }

    public int getTotal_Count() {
        return this.totalCount;
    }

    public String getNext_Page() {
        return this.nextPage;
    }

    public List<SchedulePayload> getSchedules() {
        return this.scheduleObjects;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.count, this.totalCount, this.nextPage, this.scheduleObjects});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ListAllSchedulesResponse other = (ListAllSchedulesResponse)obj;
        return Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal((Object)this.count, (Object)other.count) && Objects.equal((Object)this.totalCount, (Object)other.totalCount) && Objects.equal((Object)this.nextPage, (Object)other.nextPage) && Objects.equal(this.scheduleObjects, other.scheduleObjects);
    }

    public String toString() {
        return "APIListScheduleResponse{ok=" + this.ok + ", count=" + this.count + ", totalCount=" + this.totalCount + ", nextPage=" + this.nextPage + ", scheduleObjects=" + this.scheduleObjects + '}';
    }

    public static class Builder {
        private boolean ok = false;
        private int count;
        private int total_count;
        private String next_page;
        private ImmutableList.Builder<SchedulePayload> scheduleresponse = ImmutableList.builder();

        private Builder() {
        }

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setCount(int count) {
            this.count = count;
            return this;
        }

        public Builder setTotalCount(int total_count) {
            this.total_count = total_count;
            return this;
        }

        public Builder setNextPage(String next_page) {
            this.next_page = next_page;
            return this;
        }

        public Builder addSchedule(SchedulePayload schedule) {
            this.scheduleresponse.add((Object)schedule);
            return this;
        }

        public Builder addAllSchedule(Iterable<? extends SchedulePayload> schedulelist) {
            this.scheduleresponse.addAll(schedulelist);
            return this;
        }

        public ListAllSchedulesResponse build() {
            Preconditions.checkNotNull((Object)this.count, (Object)"count must be set to build APIListScheduleResponse");
            Preconditions.checkNotNull((Object)this.total_count, (Object)"total count must be set to build APIListScheduleResponse");
            Preconditions.checkNotNull(this.scheduleresponse, (Object)"sch must be set to build APIListScheduleResponse");
            return new ListAllSchedulesResponse(this.ok, this.count, this.total_count, this.next_page, this.scheduleresponse.build());
        }
    }
}

