/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.push.model.PushPayload;
import com.urbanairship.api.schedule.model.Schedule;
import com.urbanairship.api.schedule.model.SchedulePayload;
import com.urbanairship.api.schedule.model.ScheduleResponse;
import com.urbanairship.api.schedule.parse.ScheduleObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;

public class ScheduleRequest
implements Request<ScheduleResponse> {
    static final String API_SCHEDULE_PATH = "/api/schedules/";
    private final Schedule schedule;
    private final PushPayload pushPayload;
    private final String path;
    private final Request.HttpMethod method;
    private String name;

    private ScheduleRequest(Schedule schedule, PushPayload pushPayload, Request.HttpMethod method, String path) {
        this.schedule = schedule;
        this.pushPayload = pushPayload;
        this.path = path;
        this.method = method;
    }

    public static ScheduleRequest newRequest(Schedule schedule, PushPayload payload) {
        Preconditions.checkNotNull((Object)schedule, (Object)"Schedule may not be null");
        Preconditions.checkNotNull((Object)payload, (Object)"Push payload may not be null");
        return new ScheduleRequest(schedule, payload, Request.HttpMethod.POST, API_SCHEDULE_PATH);
    }

    public static ScheduleRequest newUpdateRequest(Schedule schedule, PushPayload payload, String scheduleId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)scheduleId), (Object)"Schedule ID may not be mull");
        Preconditions.checkNotNull((Object)schedule, (Object)"Schedule may not be null");
        Preconditions.checkNotNull((Object)payload, (Object)"Push payload may not be null");
        return new ScheduleRequest(schedule, payload, Request.HttpMethod.PUT, API_SCHEDULE_PATH + scheduleId);
    }

    public ScheduleRequest setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return this.method;
    }

    @Override
    public String getRequestBody() {
        return SchedulePayload.newBuilder().setName(this.name).setPushPayload(this.pushPayload).setSchedule(this.schedule).build().toJSON();
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<ScheduleResponse> getResponseParser() {
        return new ResponseParser<ScheduleResponse>(){

            @Override
            public ScheduleResponse parse(String response) throws IOException {
                return (ScheduleResponse)ScheduleObjectMapper.getInstance().readValue(response, ScheduleResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }
}

