/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.common.parse.DateFormats;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class StatisticsCsvRequest
implements Request<String> {
    private static final String API_STATISTICS = "/api/push/stats/";
    private final DateTime start;
    private final DateTime end;

    private StatisticsCsvRequest() {
        this(null, null);
    }

    private StatisticsCsvRequest(DateTime start, DateTime end) {
        this.start = start;
        this.end = end;
    }

    public static StatisticsCsvRequest newRequest(DateTime start, DateTime end) {
        return new StatisticsCsvRequest(start, end);
    }

    @Override
    public ContentType getContentType() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return null;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        Preconditions.checkNotNull((Object)this.start, (Object)"start cannot be null");
        Preconditions.checkNotNull((Object)this.end, (Object)"end cannot be null");
        Preconditions.checkArgument((boolean)this.end.isAfter((ReadableInstant)this.start), (Object)"end must occur after start");
        URIBuilder builder = new URIBuilder(RequestUtils.resolveURI(baseUri, API_STATISTICS));
        builder.addParameter("start", this.start.toString(DateFormats.DATE_FORMATTER));
        builder.addParameter("end", this.end.toString(DateFormats.DATE_FORMATTER));
        builder.addParameter("format", "csv");
        return builder.build();
    }

    @Override
    public ResponseParser<String> getResponseParser() {
        return new ResponseParser<String>(){

            @Override
            public String parse(String response) throws IOException {
                return response;
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }
}

