/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports;

import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.reports.model.PushInfoResponse;
import com.urbanairship.api.reports.parse.ReportsObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class PushInfoRequest
implements Request<PushInfoResponse> {
    private static final String API_PUSH_RESPONSE_STATS = "/api/reports/responses/";
    private final String path;

    private PushInfoRequest(String path) {
        this.path = path;
    }

    public static PushInfoRequest newRequest(String uuid) {
        return new PushInfoRequest(API_PUSH_RESPONSE_STATS + uuid);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<PushInfoResponse> getResponseParser() {
        return new ResponseParser<PushInfoResponse>(){

            @Override
            public PushInfoResponse parse(String response) throws IOException {
                return (PushInfoResponse)ReportsObjectMapper.getInstance().readValue(response, PushInfoResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }
}

