/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.audience;

import com.google.common.collect.ImmutableList;
import com.urbanairship.api.push.model.audience.BasicCompoundSelector;
import com.urbanairship.api.push.model.audience.BasicSelector;
import com.urbanairship.api.push.model.audience.BasicValueSelector;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.push.model.audience.SelectorType;
import com.urbanairship.api.push.model.audience.location.DateRange;
import com.urbanairship.api.push.model.audience.location.DateRangeUnit;
import com.urbanairship.api.push.model.audience.location.LocationAlias;
import com.urbanairship.api.push.model.audience.location.LocationIdentifier;
import com.urbanairship.api.push.model.audience.location.LocationSelector;
import com.urbanairship.api.push.model.audience.location.PresenceTimeframe;
import com.urbanairship.api.push.model.audience.location.RecentDateRange;
import java.util.Collection;

public class Selectors {
    public static final String GROUP_ATTR = "group";
    public static final String CLASS_ATTR = "tag_class";

    public static final Selector atomic(SelectorType type) {
        return BasicSelector.newBuilder().setType(type).build();
    }

    public static final Selector value(SelectorType type, String value) {
        return BasicValueSelector.newBuilder().setType(type).setValue(value).build();
    }

    public static final Selector compound(SelectorType type, Selector ... children) {
        BasicCompoundSelector.Builder builder = BasicCompoundSelector.newBuilder().setType(type);
        for (Selector child : children) {
            builder.addSelector(child);
        }
        return builder.build();
    }

    public static final Selector compound(SelectorType type, Collection<Selector> children) {
        return Selectors.compound(type, children.toArray(new Selector[0]));
    }

    public static final Selector compound(SelectorType type, SelectorType childType, String ... values) {
        ImmutableList.Builder children = ImmutableList.builder();
        for (String value : values) {
            children.add((Object)BasicValueSelector.newBuilder().setType(childType).setValue(value).build());
        }
        return BasicCompoundSelector.newBuilder().setType(type).addAllSelectors((Iterable<Selector>)children.build()).build();
    }

    public static final Selector compound(SelectorType type, SelectorType childType, Collection<String> values) {
        return Selectors.compound(type, childType, values.toArray(new String[0]));
    }

    public static final Selector broadcast() {
        return Selectors.atomic(SelectorType.ALL);
    }

    public static final Selector all() {
        return Selectors.atomic(SelectorType.ALL);
    }

    public static final Selector triggered() {
        return Selectors.atomic(SelectorType.TRIGGERED);
    }

    public static final Selector tag(String tag) {
        return Selectors.value(SelectorType.TAG, tag);
    }

    public static final Selector tags(String ... tags) {
        return Selectors.compound(SelectorType.OR, SelectorType.TAG, tags);
    }

    public static final Selector tags(Collection<String> tags) {
        return Selectors.compound(SelectorType.OR, SelectorType.TAG, tags);
    }

    public static final Selector tagWithGroup(String tag, String group) {
        return BasicValueSelector.newBuilder().setType(SelectorType.TAG).setValue(tag).addAttribute(GROUP_ATTR, group).build();
    }

    public static final Selector tagWithClass(String tag, String tagClass) {
        return BasicValueSelector.newBuilder().setType(SelectorType.TAG).setValue(tag).addAttribute(CLASS_ATTR, tagClass).build();
    }

    public static final Selector staticList(String staticList) {
        return Selectors.value(SelectorType.STATIC_LIST, staticList);
    }

    public static final Selector staticLists(String ... staticLists) {
        return Selectors.compound(SelectorType.OR, SelectorType.STATIC_LIST, staticLists);
    }

    public static final Selector staticLists(Collection<String> staticLists) {
        return Selectors.compound(SelectorType.OR, SelectorType.STATIC_LIST, staticLists);
    }

    public static final Selector autogroup(int value) {
        return Selectors.autogroup(Integer.toString(value));
    }

    public static final Selector autogroup(String value) {
        return Selectors.tagWithClass(value, "autogroup");
    }

    public static final Selector alias(String alias) {
        return Selectors.value(SelectorType.ALIAS, alias);
    }

    public static final Selector aliases(String ... aliases) {
        return Selectors.compound(SelectorType.OR, SelectorType.ALIAS, aliases);
    }

    public static final Selector aliases(Collection<String> aliases) {
        return Selectors.compound(SelectorType.OR, SelectorType.ALIAS, aliases);
    }

    public static final Selector namedUser(String namedUser) {
        return Selectors.value(SelectorType.NAMED_USER, namedUser);
    }

    public static final Selector namedUsers(String ... namedUsers) {
        return Selectors.compound(SelectorType.OR, SelectorType.NAMED_USER, namedUsers);
    }

    public static final Selector namedUsers(Collection<String> namedUsers) {
        return Selectors.compound(SelectorType.OR, SelectorType.NAMED_USER, namedUsers);
    }

    public static final Selector segment(String segment) {
        return Selectors.value(SelectorType.SEGMENT, segment);
    }

    public static final Selector segments(String ... segments) {
        return Selectors.compound(SelectorType.OR, SelectorType.SEGMENT, segments);
    }

    public static final Selector segments(Collection<String> segments) {
        return Selectors.compound(SelectorType.OR, SelectorType.SEGMENT, segments);
    }

    public static final Selector deviceToken(String deviceToken) {
        return Selectors.value(SelectorType.DEVICE_TOKEN, deviceToken);
    }

    public static final Selector deviceTokens(String ... deviceTokens) {
        return Selectors.compound(SelectorType.OR, SelectorType.DEVICE_TOKEN, deviceTokens);
    }

    public static final Selector deviceTokens(Collection<String> deviceTokens) {
        return Selectors.compound(SelectorType.OR, SelectorType.DEVICE_TOKEN, deviceTokens);
    }

    public static final Selector channel(String channel) {
        return Selectors.value(SelectorType.CHANNEL, channel);
    }

    public static final Selector iosChannel(String iosChannel) {
        return Selectors.value(SelectorType.IOS_CHANNEL, iosChannel);
    }

    public static final Selector iosChannels(String ... iosChannels) {
        return Selectors.compound(SelectorType.OR, SelectorType.IOS_CHANNEL, iosChannels);
    }

    public static final Selector iosChannels(Collection<String> iosChannels) {
        return Selectors.compound(SelectorType.OR, SelectorType.IOS_CHANNEL, iosChannels);
    }

    public static final Selector apid(String apid) {
        return Selectors.value(SelectorType.APID, apid);
    }

    public static final Selector apids(String ... apids) {
        return Selectors.compound(SelectorType.OR, SelectorType.APID, apids);
    }

    public static final Selector apids(Collection<String> apids) {
        return Selectors.compound(SelectorType.OR, SelectorType.APID, apids);
    }

    public static final Selector androidChannel(String androidChannel) {
        return Selectors.value(SelectorType.ANDROID_CHANNEL, androidChannel);
    }

    public static final Selector androidChannels(String ... androidChannels) {
        return Selectors.compound(SelectorType.OR, SelectorType.ANDROID_CHANNEL, androidChannels);
    }

    public static final Selector androidChannels(Collection<String> androidChannels) {
        return Selectors.compound(SelectorType.OR, SelectorType.ANDROID_CHANNEL, androidChannels);
    }

    public static final Selector wns(String wns) {
        return Selectors.value(SelectorType.WNS, wns);
    }

    public static final Selector wnsDevices(String ... ids) {
        return Selectors.compound(SelectorType.OR, SelectorType.WNS, ids);
    }

    public static final Selector wnsDevices(Collection<String> ids) {
        return Selectors.compound(SelectorType.OR, SelectorType.WNS, ids);
    }

    public static final Selector amazon(String id) {
        return Selectors.value(SelectorType.AMAZON_CHANNEL, id);
    }

    public static final Selector amazonDevices(String ... ids) {
        return Selectors.compound(SelectorType.OR, SelectorType.AMAZON_CHANNEL, ids);
    }

    public static final Selector amazonDevices(Collection<String> ids) {
        return Selectors.compound(SelectorType.OR, SelectorType.AMAZON_CHANNEL, ids);
    }

    public static final Selector or(Selector ... children) {
        return Selectors.compound(SelectorType.OR, children);
    }

    public static final Selector or(Collection<Selector> children) {
        return Selectors.compound(SelectorType.OR, children);
    }

    public static final Selector or(SelectorType childType, String ... values) {
        return Selectors.compound(SelectorType.OR, childType, values);
    }

    public static final Selector or(SelectorType childType, Collection<String> values) {
        return Selectors.compound(SelectorType.OR, childType, values);
    }

    public static final Selector and(Selector ... children) {
        return Selectors.compound(SelectorType.AND, children);
    }

    public static final Selector and(Collection<Selector> children) {
        return Selectors.compound(SelectorType.AND, children);
    }

    public static final Selector not(Selector child) {
        return Selectors.compound(SelectorType.NOT, child);
    }

    public static final Selector location(String id, DateRange range) {
        return LocationSelector.newBuilder().setId(LocationIdentifier.newBuilder().setId(id).build()).setDateRange(range).build();
    }

    public static final Selector location(String type, String value, DateRange range) {
        return LocationSelector.newBuilder().setId(LocationIdentifier.newBuilder().setAlias(LocationAlias.newBuilder().setType(type).setValue(value).build()).build()).setDateRange(range).build();
    }

    public static final DateRange minutes(int units) {
        return Selectors.minutes(units, PresenceTimeframe.ANYTIME);
    }

    public static final DateRange minutes(int units, PresenceTimeframe timeframe) {
        return RecentDateRange.newBuilder().setResolution(DateRangeUnit.MINUTES).setTimeframe(timeframe).setUnits(units).build();
    }

    public static final DateRange minutesLastSeen(int units) {
        return Selectors.minutes(units, PresenceTimeframe.LAST_SEEN);
    }

    public static final DateRange hours(int units) {
        return Selectors.hours(units, PresenceTimeframe.ANYTIME);
    }

    public static final DateRange hours(int units, PresenceTimeframe timeframe) {
        return RecentDateRange.newBuilder().setResolution(DateRangeUnit.HOURS).setTimeframe(timeframe).setUnits(units).build();
    }

    public static final DateRange hoursLastSeen(int units) {
        return Selectors.hours(units, PresenceTimeframe.LAST_SEEN);
    }

    public static final DateRange days(int units) {
        return Selectors.days(units, PresenceTimeframe.ANYTIME);
    }

    public static final DateRange days(int units, PresenceTimeframe timeframe) {
        return RecentDateRange.newBuilder().setResolution(DateRangeUnit.DAYS).setTimeframe(timeframe).setUnits(units).build();
    }

    public static final DateRange daysLastSeen(int units) {
        return Selectors.days(units, PresenceTimeframe.LAST_SEEN);
    }

    public static final DateRange weeks(int units) {
        return Selectors.weeks(units, PresenceTimeframe.ANYTIME);
    }

    public static final DateRange weeks(int units, PresenceTimeframe timeframe) {
        return RecentDateRange.newBuilder().setResolution(DateRangeUnit.WEEKS).setTimeframe(timeframe).setUnits(units).build();
    }

    public static final DateRange weeksLastSeen(int units) {
        return Selectors.weeks(units, PresenceTimeframe.LAST_SEEN);
    }

    public static final DateRange months(int units) {
        return Selectors.months(units, PresenceTimeframe.ANYTIME);
    }

    public static final DateRange months(int units, PresenceTimeframe timeframe) {
        return RecentDateRange.newBuilder().setResolution(DateRangeUnit.MONTHS).setTimeframe(timeframe).setUnits(units).build();
    }

    public static final DateRange monthsLastSeen(int units) {
        return Selectors.months(units, PresenceTimeframe.LAST_SEEN);
    }

    public static final DateRange years(int units) {
        return Selectors.years(units, PresenceTimeframe.ANYTIME);
    }

    public static final DateRange years(int units, PresenceTimeframe timeframe) {
        return RecentDateRange.newBuilder().setResolution(DateRangeUnit.YEARS).setTimeframe(timeframe).setUnits(units).build();
    }

    public static final DateRange yearsLastSeen(int units) {
        return Selectors.years(units, PresenceTimeframe.LAST_SEEN);
    }
}

