/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.audience;

import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.DeviceTypeData;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.push.model.audience.SelectorType;
import com.urbanairship.api.push.model.audience.SelectorVisitor;

public class BasicSelector
extends PushModelObject
implements Selector {
    private final SelectorType type;

    protected BasicSelector(SelectorType type) {
        this.type = type;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public SelectorType getType() {
        return this.type;
    }

    @Override
    public DeviceTypeData getApplicableDeviceTypes() {
        return DeviceTypeData.all();
    }

    @Override
    public void accept(SelectorVisitor visitor) {
        visitor.enter(this);
        visitor.exit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicSelector that = (BasicSelector)o;
        return !(this.type != null ? !this.type.equals((Object)that.type) : that.type != null);
    }

    public int hashCode() {
        return this.type != null ? this.type.hashCode() : 0;
    }

    public String toString() {
        return "BasicSelector{type=" + this.type.getIdentifier() + '}';
    }

    public static class Builder {
        private SelectorType type;

        private Builder() {
        }

        public Builder setType(SelectorType value) {
            this.type = value;
            return this;
        }

        public BasicSelector build() {
            Preconditions.checkArgument((this.type == SelectorType.ALL || this.type == SelectorType.TRIGGERED ? 1 : 0) != 0, (Object)"A unitary selector can be one of 'all' or 'triggered' only.");
            return new BasicSelector(this.type);
        }
    }
}

