/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.push.model.PushPayload;
import com.urbanairship.api.push.model.PushResponse;
import com.urbanairship.api.push.parse.PushObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class PushRequest
implements Request<PushResponse> {
    private static final String API_PUSH_PATH = "/api/push/";
    private static final String API_VALIDATE_PATH = "/api/push/validate/";
    private final List<PushPayload> payloads = new ArrayList<PushPayload>();
    private boolean validateOnly;

    private PushRequest(PushPayload payload) {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload required when creating a push request");
        this.payloads.add(payload);
    }

    private PushRequest(List<PushPayload> payloadList) {
        Preconditions.checkNotNull(payloadList, (Object)"Payload required when creating a push request");
        if (payloadList.isEmpty()) {
            throw new IllegalStateException("Payload list cannot be empty");
        }
        this.payloads.addAll(payloadList);
    }

    public static PushRequest newRequest(PushPayload payload) {
        return new PushRequest(payload);
    }

    public static PushRequest newRequest(List<PushPayload> payloadList) {
        return new PushRequest(payloadList);
    }

    public PushRequest addPayload(PushPayload newPayload) {
        Preconditions.checkNotNull((Object)newPayload, (Object)"Payload required when adding to a push request");
        this.payloads.add(newPayload);
        return this;
    }

    public PushRequest addPayloads(List<PushPayload> newPayloads) {
        Preconditions.checkNotNull(newPayloads, (Object)"Payload required when adding to a push request");
        if (newPayloads.isEmpty()) {
            throw new IllegalStateException("Payload list cannot be empty");
        }
        this.payloads.addAll(newPayloads);
        return this;
    }

    public PushRequest setValidateOnly(boolean validateOnly) {
        this.validateOnly = validateOnly;
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        if (this.payloads.size() == 1) {
            return this.payloads.get(0).toJSON();
        }
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrayNode = mapper.createArrayNode();
        for (PushPayload pushPayload : this.payloads) {
            try {
                JsonNode pushJson = mapper.readTree(pushPayload.toJSON());
                arrayNode.add(pushJson);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return arrayNode.toString();
    }

    @Override
    public URI getUri(URI baseUri) {
        String path = this.validateOnly ? API_VALIDATE_PATH : API_PUSH_PATH;
        return RequestUtils.resolveURI(baseUri, path);
    }

    @Override
    public ResponseParser<PushResponse> getResponseParser() {
        return new ResponseParser<PushResponse>(){

            @Override
            public PushResponse parse(String response) throws IOException {
                return (PushResponse)PushObjectMapper.getInstance().readValue(response, PushResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }
}

