/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.nameduser.model.NamedUserView;

public class NamedUserListingResponse {
    private final boolean ok;
    private final Optional<String> nextPage;
    private final Optional<NamedUserView> namedUserView;
    private final Optional<ImmutableList<NamedUserView>> namedUserViews;

    private NamedUserListingResponse(boolean ok, Optional<String> nextPage, Optional<NamedUserView> namedUserView, Optional<ImmutableList<NamedUserView>> namedUserViews) {
        this.ok = ok;
        this.nextPage = nextPage;
        this.namedUserView = namedUserView;
        this.namedUserViews = namedUserViews;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public Optional<String> getNextPage() {
        return this.nextPage;
    }

    public Optional<NamedUserView> getNamedUserView() {
        return this.namedUserView;
    }

    public Optional<ImmutableList<NamedUserView>> getNamedUserViews() {
        return this.namedUserViews;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.nextPage, this.namedUserView, this.namedUserViews});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NamedUserListingResponse other = (NamedUserListingResponse)obj;
        return Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal(this.nextPage, other.nextPage) && Objects.equal(this.namedUserView, other.namedUserView) && Objects.equal(this.namedUserViews, other.namedUserViews);
    }

    public String toString() {
        return "NamedUserListingResponse{ok=" + this.ok + ", nextPage=" + this.nextPage + ", namedUserView=" + this.namedUserView + ", namedUserViews=" + this.namedUserViews + '}';
    }

    public static class Builder {
        private boolean ok;
        private String nextPage = null;
        private NamedUserView namedUserView = null;
        private ImmutableList.Builder<NamedUserView> namedUserViews = ImmutableList.builder();

        private Builder() {
        }

        public Builder setOk(boolean value) {
            this.ok = value;
            return this;
        }

        public Builder setNextPage(String value) {
            this.nextPage = value;
            return this;
        }

        public Builder setNamedUserView(NamedUserView value) {
            this.namedUserView = value;
            return this;
        }

        public Builder setNamedUserViews(Iterable<? extends NamedUserView> value) {
            this.namedUserViews.addAll(value);
            return this;
        }

        public NamedUserListingResponse build() {
            if (this.namedUserView != null) {
                Preconditions.checkArgument((this.nextPage == null && this.namedUserViews.build().isEmpty() ? 1 : 0) != 0);
            }
            return new NamedUserListingResponse(this.ok, Optional.fromNullable((Object)this.nextPage), Optional.fromNullable((Object)this.namedUserView), Optional.fromNullable((Object)this.namedUserViews.build()));
        }
    }
}

