/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.location.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.location.model.LocationView;
import java.io.IOException;
import java.util.List;

public class LocationViewReader
implements JsonObjectReader<LocationView> {
    private final LocationView.Builder builder = LocationView.newBuilder();

    public void readBounds(JsonParser jsonParser) throws IOException {
        this.builder.setBounds((List)jsonParser.readValueAs((TypeReference)new TypeReference<List<Double>>(){}));
    }

    public void readCentroid(JsonParser jsonParser) throws IOException {
        this.builder.setCentroid((List)jsonParser.readValueAs((TypeReference)new TypeReference<List<Double>>(){}));
    }

    public void readId(JsonParser jsonParser) throws IOException {
        this.builder.setLocationId((String)jsonParser.readValueAs(String.class));
    }

    public void readPropertyJSONNode(JsonParser jsonParser) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        this.builder.setPropertiesNode(jsonNode);
    }

    public void readType(JsonParser jsonParser) throws IOException {
        this.builder.setLocationType((String)jsonParser.readValueAs(String.class));
    }

    @Override
    public LocationView validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage(), e);
        }
    }
}

