/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.location.model;

import com.urbanairship.api.location.model.Point;

public final class BoundedBox {
    private final Point cornerOne;
    private final Point cornerTwo;

    private BoundedBox(Point cornerOne, Point cornerTwo) {
        this.cornerOne = cornerOne;
        this.cornerTwo = cornerTwo;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Point getCornerOne() {
        return this.cornerOne;
    }

    public Point getCornerTwo() {
        return this.cornerTwo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundedBox that = (BoundedBox)o;
        if (this.cornerOne != null ? !this.cornerOne.equals(that.cornerOne) : that.cornerOne != null) {
            return false;
        }
        return !(this.cornerTwo != null ? !this.cornerTwo.equals(that.cornerTwo) : that.cornerTwo != null);
    }

    public int hashCode() {
        int result = this.cornerOne != null ? this.cornerOne.hashCode() : 0;
        result = 31 * result + (this.cornerTwo != null ? this.cornerTwo.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BoundedBox{cornerOne=" + this.cornerOne + ", cornerTwo=" + this.cornerTwo + '}';
    }

    public static class Builder {
        private Point cornerOne;
        private Point cornerTwo;

        private Builder() {
        }

        public Builder setCornerOne(Point value) {
            this.cornerOne = value;
            return this;
        }

        public Builder setCornerTwo(Point value) {
            this.cornerTwo = value;
            return this;
        }

        public BoundedBox build() {
            return new BoundedBox(this.cornerOne, this.cornerTwo);
        }
    }
}

