/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.experiments.parse;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.urbanairship.api.experiments.model.Experiment;
import com.urbanairship.api.experiments.model.ExperimentResponse;
import com.urbanairship.api.experiments.model.Variant;
import com.urbanairship.api.experiments.model.VariantPushPayload;
import com.urbanairship.api.experiments.parse.ExperimentDeserializer;
import com.urbanairship.api.experiments.parse.ExperimentResponseDeserializer;
import com.urbanairship.api.experiments.parse.ExperimentSerializer;
import com.urbanairship.api.experiments.parse.VariantDeserializer;
import com.urbanairship.api.experiments.parse.VariantPushPayloadDeserializer;
import com.urbanairship.api.experiments.parse.VariantPushPayloadSerializer;
import com.urbanairship.api.experiments.parse.VariantSerializer;
import com.urbanairship.api.push.parse.PushObjectMapper;

public class ExperimentObjectMapper {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final SimpleModule MODULE = new SimpleModule("Experiment API Module", new Version(1, 0, 0, null));

    public static SimpleModule getModule() {
        return MODULE;
    }

    public static ObjectMapper getInstance() {
        return MAPPER;
    }

    private ExperimentObjectMapper() {
    }

    static {
        MODULE.addDeserializer(Experiment.class, (JsonDeserializer)new ExperimentDeserializer()).addSerializer(Experiment.class, (JsonSerializer)new ExperimentSerializer()).addDeserializer(Variant.class, (JsonDeserializer)new VariantDeserializer()).addSerializer(Variant.class, (JsonSerializer)new VariantSerializer()).addDeserializer(VariantPushPayload.class, (JsonDeserializer)new VariantPushPayloadDeserializer()).addSerializer(VariantPushPayload.class, (JsonSerializer)new VariantPushPayloadSerializer()).addDeserializer(ExperimentResponse.class, (JsonDeserializer)new ExperimentResponseDeserializer());
        MAPPER.registerModule((Module)MODULE);
        MAPPER.registerModule((Module)PushObjectMapper.getModule());
        MAPPER.registerModule((Module)new JodaModule());
        MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
    }
}

