/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.experiments.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.urbanairship.api.experiments.model.ExperimentModelObject;
import com.urbanairship.api.experiments.model.Variant;
import com.urbanairship.api.push.model.DeviceTypeData;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.push.model.audience.SelectorType;
import java.math.BigDecimal;
import java.util.List;

public final class Experiment
extends ExperimentModelObject {
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<BigDecimal> control;
    private final Selector audience;
    private final DeviceTypeData deviceTypes;
    private final List<Variant> variants;

    private Experiment(Builder builder) {
        this.name = Optional.fromNullable((Object)builder.name);
        this.description = Optional.fromNullable((Object)builder.description);
        this.control = Optional.fromNullable((Object)builder.control);
        this.audience = builder.audience;
        this.deviceTypes = builder.deviceTypes;
        this.variants = builder.variants;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public Optional<BigDecimal> getControl() {
        return this.control;
    }

    public Selector getAudience() {
        return this.audience;
    }

    public boolean isBroadcast() {
        return this.audience.getType().equals((Object)SelectorType.ALL);
    }

    public DeviceTypeData getDeviceTypes() {
        return this.deviceTypes;
    }

    public List<Variant> getVariants() {
        return this.variants;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.description, this.control, this.audience, this.deviceTypes, this.variants});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Experiment other = (Experiment)obj;
        return Objects.equal(this.name, other.name) && Objects.equal(this.description, other.description) && Objects.equal(this.control, other.control) && Objects.equal((Object)this.audience, (Object)other.audience) && Objects.equal((Object)this.deviceTypes, (Object)other.deviceTypes) && Objects.equal(this.variants, other.variants);
    }

    public String toString() {
        return "Experiment{name=" + this.name + ", description=" + this.description + ", control=" + this.control + ", audience=" + this.audience + ", deviceTypes=" + this.deviceTypes + ", variants=" + this.variants + '}';
    }

    public static class Builder {
        private String name = null;
        private String description = null;
        private BigDecimal control = null;
        private Selector audience = null;
        private DeviceTypeData deviceTypes = null;
        private List<Variant> variants = Lists.newArrayList();

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setControl(BigDecimal control) {
            this.control = control;
            return this;
        }

        public Builder setAudience(Selector audience) {
            this.audience = audience;
            return this;
        }

        public Builder setDeviceTypes(DeviceTypeData deviceTypes) {
            this.deviceTypes = deviceTypes;
            return this;
        }

        public Builder addVariant(Variant variant) {
            this.variants.add(variant);
            return this;
        }

        public Builder addAllVariants(List<Variant> variants) {
            this.variants.addAll(variants);
            return this;
        }

        public Experiment build() {
            Preconditions.checkNotNull((Object)this.audience, (Object)"'audience' must be set");
            Preconditions.checkNotNull((Object)this.deviceTypes, (Object)"'device_types' must be set");
            Preconditions.checkNotNull(this.variants, (Object)"An experiment requires at least one variant.");
            Preconditions.checkArgument((this.variants.size() > 0 ? 1 : 0) != 0, (Object)"At least one variant must be present.");
            return new Experiment(this);
        }
    }
}

