/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.google.common.base.Optional;
import com.urbanairship.api.client.RequestError;

public class ServerException
extends RuntimeException {
    private final String statusText;
    private final Integer statusCode;
    private final Optional<RequestError> error;

    private ServerException(String statusText, Integer statusCode, Optional<RequestError> error) {
        super(statusText);
        this.statusText = statusText;
        this.statusCode = statusCode;
        this.error = error;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getStatusText() {
        return this.statusText;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public Optional<RequestError> getError() {
        return this.error;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nServerException:");
        stringBuilder.append(String.format("\nMessage:%s", this.getMessage()));
        stringBuilder.append(String.format("\nStatusCode:%s", this.statusCode));
        stringBuilder.append(String.format("\nStatusText:%s", this.statusText));
        if (this.error.isPresent()) {
            stringBuilder.append(String.format("\nError:%s", this.error.get()));
        }
        if (this.getCause() != null) {
            stringBuilder.append(String.format("\nCause:%s", this.getCause().getMessage()));
        }
        return stringBuilder.toString();
    }

    public static class Builder {
        private Integer statusCode;
        private String statusText;
        private RequestError requestError = null;

        public Builder setStatusText(String statusText) {
            this.statusText = statusText;
            return this;
        }

        public Builder setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setRequestError(RequestError requestError) {
            this.requestError = requestError;
            return this;
        }

        public ServerException build() {
            return new ServerException(this.statusText, this.statusCode, Optional.fromNullable((Object)this.requestError));
        }
    }
}

