/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.google.common.base.Optional;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.urbanairship.api.client.ClientException;
import com.urbanairship.api.client.RequestError;
import com.urbanairship.api.client.Response;
import com.urbanairship.api.client.ResponseCallback;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.client.ServerException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResponseAsyncHandler<T>
implements AsyncHandler<Response> {
    private static final Logger log = LoggerFactory.getLogger(ResponseAsyncHandler.class);
    private static final String CONTENT_TYPE_KEY = "Content-type";
    private final Response.Builder<T> responseBuilder = new Response.Builder();
    private final ClientException.Builder exceptionBuilder = ClientException.newBuilder();
    private final ServerException.Builder serverExceptionBuilder = ServerException.newBuilder();
    private final Optional<ResponseCallback> clientCallback;
    private final ResponseParser<T> parser;
    private final StringBuilder bodyBuilder = new StringBuilder();
    private AtomicInteger retryCount = new AtomicInteger(0);
    private String exceptionContentType;
    private boolean isSuccessful;
    private Integer statusCode;

    public ResponseAsyncHandler(Optional<ResponseCallback> clientCallback, ResponseParser<T> parser) {
        this.clientCallback = clientCallback;
        this.parser = parser;
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        this.statusCode = responseStatus.getStatusCode();
        if (this.statusCode >= 200 && this.statusCode < 300) {
            this.responseBuilder.setStatus(responseStatus.getStatusCode());
            this.isSuccessful = true;
        } else if (this.statusCode >= 500) {
            this.serverExceptionBuilder.setStatusCode(this.statusCode);
            this.serverExceptionBuilder.setStatusText(responseStatus.getStatusText());
            this.isSuccessful = false;
        } else {
            this.exceptionBuilder.setStatusText(responseStatus.getStatusText());
            this.exceptionBuilder.setStatusCode(this.statusCode);
            this.isSuccessful = false;
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        if (this.isSuccessful) {
            this.responseBuilder.setHeaders(this.getHeaders(headers));
        } else {
            this.exceptionContentType = headers.getHeaders().getFirstValue(CONTENT_TYPE_KEY);
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        String body = new String(bodyPart.getBodyPartBytes(), StandardCharsets.UTF_8);
        if (!this.isSuccessful) {
            RequestError error = RequestError.errorFromResponse(body, this.exceptionContentType);
            if (this.statusCode >= 500) {
                this.serverExceptionBuilder.setRequestError(error);
                throw this.serverExceptionBuilder.build();
            }
            this.exceptionBuilder.setRequestError(error);
            throw this.exceptionBuilder.build();
        }
        this.bodyBuilder.append(body);
        return AsyncHandler.STATE.CONTINUE;
    }

    public Response onCompleted() throws Exception {
        if (StringUtils.isNotBlank((String)this.bodyBuilder.toString())) {
            this.responseBuilder.setBody(this.parser.parse(this.bodyBuilder.toString()));
        }
        Response response = this.responseBuilder.build();
        if (this.clientCallback.isPresent()) {
            ((ResponseCallback)this.clientCallback.get()).completed(response);
        }
        log.debug("Response processing completed for " + response.getBody());
        return response;
    }

    public void onThrowable(Throwable t) {
        log.error("Exception thrown during response processing", t);
        if (this.clientCallback.isPresent()) {
            ((ResponseCallback)this.clientCallback.get()).error(t);
        }
    }

    private Map<String, Collection<String>> getHeaders(HttpResponseHeaders httpResponse) {
        HashMap<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
        for (Map.Entry entry : httpResponse.getHeaders().entrySet()) {
            headers.put((String)entry.getKey(), (Collection<String>)entry.getValue());
        }
        return headers;
    }

    public int getRetryCount() {
        return this.retryCount.get();
    }

    public void incrementRetryCount() {
        this.retryCount.incrementAndGet();
    }
}

