/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.urbanairship.api.client.RequestErrorDetails;
import com.urbanairship.api.client.parse.RequestErrorObjectMapper;
import java.io.IOException;
import java.util.Map;

public final class RequestError {
    private static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String UA_APPLICATION_JSON = "application/vnd.urbanairship+json";
    private static final String UA_APPLICATION_JSON_V3 = "application/vnd.urbanairship+json;version=3";
    private final boolean ok;
    private final Optional<String> operationId;
    private final String error;
    private final Optional<Number> errorCode;
    private final Optional<RequestErrorDetails> details;

    private RequestError(boolean ok, Optional<String> operationId, String error, Optional<Number> errorCode, Optional<RequestErrorDetails> details) {
        this.ok = ok;
        this.operationId = operationId;
        if (error == null || error.isEmpty()) {
            throw new IllegalArgumentException("Error cannot be null or empty");
        }
        this.error = error;
        this.errorCode = errorCode;
        this.details = details;
    }

    public static RequestError errorFromResponse(String body, String contentType) throws IOException {
        if (contentType.equalsIgnoreCase(CONTENT_TYPE_TEXT_HTML)) {
            return RequestError.nonJSONError(body);
        }
        if (contentType.equalsIgnoreCase(CONTENT_TYPE_JSON)) {
            return RequestError.nonV3JSONError(body);
        }
        if (contentType.equalsIgnoreCase(UA_APPLICATION_JSON) || contentType.equalsIgnoreCase(UA_APPLICATION_JSON_V3)) {
            ObjectMapper mapper = RequestErrorObjectMapper.getInstance();
            return (RequestError)mapper.readValue(body, RequestError.class);
        }
        return RequestError.newBuilder().setError("Unknown response parsing error").build();
    }

    @Deprecated
    private static RequestError nonJSONError(String body) throws IOException {
        return RequestError.newBuilder().setError(body).build();
    }

    @Deprecated
    private static RequestError nonV3JSONError(String body) throws IOException {
        ObjectMapper mapper = RequestErrorObjectMapper.getInstance();
        Map errorMsg = (Map)mapper.readValue(body, (TypeReference)new TypeReference<Map<String, String>>(){});
        return RequestError.newBuilder().setError((String)errorMsg.get("message")).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public Optional<String> getOperationId() {
        return this.operationId;
    }

    public String getError() {
        return this.error;
    }

    public Optional<Number> getErrorCode() {
        return this.errorCode;
    }

    public Optional<RequestErrorDetails> getDetails() {
        return this.details;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ok:");
        stringBuilder.append(this.getOk());
        stringBuilder.append("\nRequestError:");
        stringBuilder.append(this.getError());
        if (this.errorCode.isPresent()) {
            stringBuilder.append("\nCode:");
            stringBuilder.append(this.getErrorCode());
        }
        if (this.details.isPresent()) {
            stringBuilder.append("\nDetails:");
            stringBuilder.append(((RequestErrorDetails)this.details.get()).toString());
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestError)) {
            return false;
        }
        RequestError that = (RequestError)o;
        if (this.ok != that.ok) {
            return false;
        }
        if (this.details != null ? !this.details.equals(that.details) : that.details != null) {
            return false;
        }
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        if (this.errorCode != null ? !this.errorCode.equals(that.errorCode) : that.errorCode != null) {
            return false;
        }
        return !(this.operationId != null ? !this.operationId.equals(that.operationId) : that.operationId != null);
    }

    public int hashCode() {
        int result = this.ok ? 1 : 0;
        result = 31 * result + (this.operationId != null ? this.operationId.hashCode() : 0);
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + (this.errorCode != null ? this.errorCode.hashCode() : 0);
        result = 31 * result + (this.details != null ? this.details.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private boolean ok;
        private String operationId;
        private String error;
        private Number errorCode;
        private RequestErrorDetails details;

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setOperationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorCode(Number errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder setDetails(RequestErrorDetails details) {
            this.details = details;
            return this;
        }

        public RequestError build() {
            return new RequestError(this.ok, Optional.fromNullable((Object)this.operationId), this.error, Optional.fromNullable((Object)this.errorCode), Optional.fromNullable((Object)this.details));
        }
    }
}

