/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import androidx.databinding.DataBindingUtil;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.controller.FileType;
import com.uploadcare.android.widget.controller.SocialNetwork;
import com.uploadcare.android.widget.data.SocialSource;
import com.uploadcare.android.widget.data.Urls;
import com.uploadcare.android.widget.databinding.UcwDialogNetworkItemBinding;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u0012\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0002R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/uploadcare/android/widget/adapter/SocialNetworksAdapter;", "Landroid/widget/ArrayAdapter;", "Lcom/uploadcare/android/widget/data/SocialSource;", "context", "Landroid/content/Context;", "fileType", "Lcom/uploadcare/android/widget/controller/FileType;", "sources", "", "clickObserver", "Lkotlin/Function1;", "", "(Landroid/content/Context;Lcom/uploadcare/android/widget/controller/FileType;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "inflater", "Landroid/view/LayoutInflater;", "clear", "getCount", "", "getItem", "position", "getItemId", "", "getView", "Landroid/view/View;", "convertView", "parent", "Landroid/view/ViewGroup;", "isEmpty", "", "onSocialSourceSelected", "socialSource", "Companion", "widget_release"})
@SourceDebugExtension(value={"SMAP\nSocialNetworksAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocialNetworksAdapter.kt\ncom/uploadcare/android/widget/adapter/SocialNetworksAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1002#2,2:101\n1#3:103\n*S KotlinDebug\n*F\n+ 1 SocialNetworksAdapter.kt\ncom/uploadcare/android/widget/adapter/SocialNetworksAdapter\n*L\n27#1:101,2\n*E\n"})
public final class SocialNetworksAdapter
extends ArrayAdapter<SocialSource> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<SocialSource> sources;
    @Nullable
    private final Function1<SocialSource, Unit> clickObserver;
    @NotNull
    private final LayoutInflater inflater;
    @NotNull
    private static final SocialSource socialFile = new SocialSource(CollectionsKt.emptyList(), SocialNetwork.SOCIAL_NETWORK_FILE.getRawValue(), new Urls("", "", ""));
    @NotNull
    private static final SocialSource socialImages = new SocialSource(CollectionsKt.emptyList(), SocialNetwork.SOCIAL_NETWORK_CAMERA.getRawValue(), new Urls("", "", ""));
    @NotNull
    private static final SocialSource socialVideos = new SocialSource(CollectionsKt.emptyList(), SocialNetwork.SOCIAL_NETWORK_VIDEOCAM.getRawValue(), new Urls("", "", ""));

    public SocialNetworksAdapter(@NotNull Context context, @Nullable FileType fileType, @NotNull List<SocialSource> sources, @Nullable Function1<? super SocialSource, Unit> clickObserver) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        super(context, R.layout.ucw_dialog_network_item);
        this.sources = sources;
        this.clickObserver = clickObserver;
        Object object = context.getSystemService("layout_inflater");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.LayoutInflater");
        this.inflater = (LayoutInflater)object;
        List<SocialSource> $this$sortBy$iv = this.sources;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    SocialSource it = (SocialSource)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (SocialSource)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
        }
        this.sources.add(0, socialFile);
        boolean hasCamera = context.getPackageManager().hasSystemFeature("android.hardware.camera");
        if (hasCamera) {
            FileType fileType2 = fileType;
            switch (fileType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[fileType2.ordinal()]) {
                case 1: {
                    this.sources.add(0, socialImages);
                    break;
                }
                case 2: {
                    this.sources.add(0, socialVideos);
                    break;
                }
                default: {
                    this.sources.add(0, socialVideos);
                    this.sources.add(0, socialImages);
                }
            }
        }
    }

    public /* synthetic */ SocialNetworksAdapter(Context context, FileType fileType, List list, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            fileType = FileType.any;
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        this(context, fileType, list, (Function1<? super SocialSource, Unit>)function1);
    }

    @SuppressLint(value={"ViewHolder"})
    @NotNull
    public View getView(int position, @Nullable View convertView, @NotNull ViewGroup parent) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                object = convertView;
                if (object == null) break block2;
                View it = object;
                boolean bl = false;
                UcwDialogNetworkItemBinding ucwDialogNetworkItemBinding = (UcwDialogNetworkItemBinding)DataBindingUtil.getBinding((View)convertView);
                object = ucwDialogNetworkItemBinding;
                if (ucwDialogNetworkItemBinding != null) break block3;
            }
            object = UcwDialogNetworkItemBinding.inflate(this.inflater, parent, false);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"convertView?.let {\n     \u2026(inflater, parent, false)");
        View binding = object;
        binding.setAdapter(this);
        binding.setSocialSource(this.getItem(position));
        binding.executePendingBindings();
        binding.invalidateAll();
        View view = binding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"binding.root");
        return view;
    }

    public final void onSocialSourceSelected(@NotNull SocialSource socialSource) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)socialSource, (String)"socialSource");
            Function1<SocialSource, Unit> function1 = this.clickObserver;
            if (function1 == null) break block0;
            Function1<SocialSource, Unit> it = function1;
            boolean bl = false;
            it.invoke((Object)socialSource);
        }
    }

    @Nullable
    public SocialSource getItem(int position) {
        return this.sources.get(position);
    }

    public boolean isEmpty() {
        return this.sources.isEmpty();
    }

    public int getCount() {
        return this.sources.size();
    }

    public long getItemId(int position) {
        return position;
    }

    public void clear() {
        super.clear();
        this.sources.clear();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/uploadcare/android/widget/adapter/SocialNetworksAdapter$Companion;", "", "()V", "socialFile", "Lcom/uploadcare/android/widget/data/SocialSource;", "socialImages", "socialVideos", "widget_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileType.values().length];
            try {
                nArray[FileType.image.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileType.video.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

