/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.data;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.webkit.CookieManager;
import com.squareup.moshi.Json;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.data.Chunk;
import com.uploadcare.android.widget.data.Urls;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.android.parcel.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B*\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\u000e\u0010\u0013\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u00c6\u0003J2\u0010\u0014\u001a\u00020\u00002\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\r\b\u0002\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u00c6\u0001J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\u000e\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010 \u001a\u00020\u001aJ\u0006\u0010!\u001a\u00020\u001aJ\t\u0010\"\u001a\u00020\u001aH\u00d6\u0001J\u0016\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0006J\t\u0010%\u001a\u00020\u0006H\u00d6\u0001J\u0019\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lcom/uploadcare/android/widget/data/SocialSource;", "Landroid/os/Parcelable;", "rootChunks", "", "Lcom/uploadcare/android/widget/data/Chunk;", "name", "", "urls", "Lcom/uploadcare/android/widget/data/Urls;", "Lkotlinx/android/parcel/RawValue;", "(Ljava/util/List;Ljava/lang/String;Lcom/uploadcare/android/widget/data/Urls;)V", "getName", "()Ljava/lang/String;", "getRootChunks", "()Ljava/util/List;", "getUrls", "()Lcom/uploadcare/android/widget/data/Urls;", "component1", "component2", "component3", "copy", "deleteCookie", "", "context", "Landroid/content/Context;", "describeContents", "", "equals", "", "other", "", "getCookie", "getNetworkIconResource", "getNetworkNameResource", "hashCode", "saveCookie", "cookie", "toString", "writeToParcel", "parcel", "Landroid/os/Parcel;", "flags", "widget_release"})
@Parcelize
public final class SocialSource
implements Parcelable {
    @NotNull
    private final List<Chunk> rootChunks;
    @NotNull
    private final String name;
    @NotNull
    private final Urls urls;
    public static final Parcelable.Creator CREATOR = new Creator();

    public final void saveCookie(@NotNull Context context, @NotNull String cookie) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putString("UCW_PREF_" + this.name, cookie).apply();
    }

    @NotNull
    public final String getCookie(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = PreferenceManager.getDefaultSharedPreferences((Context)context).getString("UCW_PREF_" + this.name, null);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public final void deleteCookie(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        CookieManager.getInstance().removeAllCookies(null);
        preferences.edit().remove("UCW_PREF_" + this.name).apply();
    }

    public final int getNetworkNameResource() {
        int n;
        switch (this.name) {
            case "facebook": {
                n = R.string.ucw_social_facebook;
                break;
            }
            case "instagram": {
                n = R.string.ucw_social_instagram;
                break;
            }
            case "vk": {
                n = R.string.ucw_social_vk;
                break;
            }
            case "box": {
                n = R.string.ucw_social_box;
                break;
            }
            case "huddle": {
                n = R.string.ucw_social_huddle;
                break;
            }
            case "flickr": {
                n = R.string.ucw_social_flickr;
                break;
            }
            case "evernote": {
                n = R.string.ucw_social_evernote;
                break;
            }
            case "skydrive": {
                n = R.string.ucw_social_skydrive;
                break;
            }
            case "dropbox": {
                n = R.string.ucw_social_dropbox;
                break;
            }
            case "gdrive": {
                n = R.string.ucw_social_gdrive;
                break;
            }
            case "video": {
                n = R.string.ucw_social_video;
                break;
            }
            case "image": {
                n = R.string.ucw_social_image;
                break;
            }
            case "file": {
                n = R.string.ucw_social_file;
                break;
            }
            case "onedrive": {
                n = R.string.ucw_social_onedrive;
                break;
            }
            case "gphotos": {
                n = R.string.ucw_social_gphotos;
                break;
            }
            default: {
                n = R.string.ucw_social_unknown;
            }
        }
        return n;
    }

    public final int getNetworkIconResource() {
        int n;
        switch (this.name) {
            case "facebook": {
                n = R.drawable.ucw_facebook_icon;
                break;
            }
            case "instagram": {
                n = R.drawable.ucw_instagram_icon;
                break;
            }
            case "vk": {
                n = R.drawable.ucw_vkontakte_icon;
                break;
            }
            case "box": {
                n = R.drawable.ucw_box_icon;
                break;
            }
            case "huddle": {
                n = R.drawable.ucw_huddle_icon;
                break;
            }
            case "flickr": {
                n = R.drawable.ucw_flickr_icon;
                break;
            }
            case "evernote": {
                n = R.drawable.ucw_evenote_icon;
                break;
            }
            case "skydrive": {
                n = R.drawable.ucw_onedrive_icon;
                break;
            }
            case "dropbox": {
                n = R.drawable.ucw_dropbox_icon;
                break;
            }
            case "gdrive": {
                n = R.drawable.ucw_googledrive_icon;
                break;
            }
            case "video": {
                n = R.drawable.ic_videocam_white_24dp;
                break;
            }
            case "image": {
                n = R.drawable.ic_photo_camera_white_24dp;
                break;
            }
            case "file": {
                n = R.drawable.ic_insert_photo_white_24dp;
                break;
            }
            case "onedrive": {
                n = R.drawable.ucw_onedrive_icon;
                break;
            }
            case "gphotos": {
                n = R.drawable.ucw_gphotos_icon;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    @NotNull
    public final List<Chunk> getRootChunks() {
        return this.rootChunks;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Urls getUrls() {
        return this.urls;
    }

    public SocialSource(@Json(name="root_chunks") @NotNull List<Chunk> rootChunks, @NotNull String name, @NotNull Urls urls) {
        Intrinsics.checkNotNullParameter(rootChunks, (String)"rootChunks");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        this.rootChunks = rootChunks;
        this.name = name;
        this.urls = urls;
    }

    @NotNull
    public final List<Chunk> component1() {
        return this.rootChunks;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final Urls component3() {
        return this.urls;
    }

    @NotNull
    public final SocialSource copy(@Json(name="root_chunks") @NotNull List<Chunk> rootChunks, @NotNull String name, @NotNull Urls urls) {
        Intrinsics.checkNotNullParameter(rootChunks, (String)"rootChunks");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        return new SocialSource(rootChunks, name, urls);
    }

    public static /* synthetic */ SocialSource copy$default(SocialSource socialSource, List list, String string2, Urls urls, int n, Object object) {
        if ((n & 1) != 0) {
            list = socialSource.rootChunks;
        }
        if ((n & 2) != 0) {
            string2 = socialSource.name;
        }
        if ((n & 4) != 0) {
            urls = socialSource.urls;
        }
        return socialSource.copy(list, string2, urls);
    }

    @NotNull
    public String toString() {
        return "SocialSource(rootChunks=" + this.rootChunks + ", name=" + this.name + ", urls=" + this.urls + ")";
    }

    public int hashCode() {
        List<Chunk> list = this.rootChunks;
        String string2 = this.name;
        Urls urls = this.urls;
        return ((list != null ? ((Object)list).hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (urls != null ? ((Object)urls).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SocialSource)) break block3;
                SocialSource socialSource = (SocialSource)object;
                if (!Intrinsics.areEqual(this.rootChunks, socialSource.rootChunks) || !Intrinsics.areEqual((Object)this.name, (Object)socialSource.name) || !Intrinsics.areEqual((Object)this.urls, (Object)socialSource.urls)) break block3;
            }
            return true;
        }
        return false;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        List<Chunk> list = this.rootChunks;
        parcel.writeInt(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator = iterator;
            ((Chunk)iterator.next()).writeToParcel(parcel, 0);
        }
        parcel.writeString(this.name);
        this.urls.writeToParcel(parcel, 0);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class Creator
    implements Parcelable.Creator {
        @NotNull
        public final Object[] newArray(int size) {
            return new SocialSource[size];
        }

        @NotNull
        public final Object createFromParcel(@NotNull Parcel in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            int n = in.readInt();
            ArrayList<Chunk> arrayList = new ArrayList<Chunk>(n);
            int n2 = n;
            while (n2 != 0) {
                arrayList.add((Chunk)Chunk.CREATOR.createFromParcel(in));
                arrayList = arrayList;
                n2 = n2 + -1;
            }
            return new SocialSource(arrayList, in.readString(), (Urls)Urls.CREATOR.createFromParcel(in));
        }
    }
}

