/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.viewmodels;

import android.app.Application;
import android.content.Context;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.MutableLiveData;
import androidx.work.Data;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.uploadcare.android.library.api.UploadcareFile;
import com.uploadcare.android.library.callbacks.UploadFileCallback;
import com.uploadcare.android.library.exceptions.UploadcareApiException;
import com.uploadcare.android.library.upload.Uploader;
import com.uploadcare.android.library.upload.UrlUploader;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.controller.UploadcareWidget;
import com.uploadcare.android.widget.data.SelectedFile;
import com.uploadcare.android.widget.data.SocialSource;
import com.uploadcare.android.widget.utils.SingleLiveEvent;
import com.uploadcare.android.widget.viewmodels.ProgressData;
import com.uploadcare.android.widget.worker.FileUploadWorker;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010%\u001a\u00020&J\u0014\u0010'\u001a\u00020&2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010)\u001a\u00020*H\u0002J\u000e\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\u0014J\u000e\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020\u0014J\u0006\u0010/\u001a\u00020&J.\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u00103\u001a\u00020&2\u0006\u00104\u001a\u000205H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000fR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\f\u00a8\u00066"}, d2={"Lcom/uploadcare/android/widget/viewmodels/UploadcareFilesViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "backgroundUpload", "", "cancelable", "closeWidgetCommand", "Lcom/uploadcare/android/widget/utils/SingleLiveEvent;", "Lcom/uploadcare/android/library/exceptions/UploadcareApiException;", "getCloseWidgetCommand", "()Lcom/uploadcare/android/widget/utils/SingleLiveEvent;", "isRoot", "Landroidx/lifecycle/MutableLiveData;", "()Landroidx/lifecycle/MutableLiveData;", "progressDialogCommand", "Lcom/uploadcare/android/widget/viewmodels/ProgressData;", "getProgressDialogCommand", "showErrorCommand", "", "getShowErrorCommand", "showProgress", "socialSource", "Lcom/uploadcare/android/widget/data/SocialSource;", "storeUponUpload", "uploadCompleteCommand", "Lcom/uploadcare/android/library/api/UploadcareFile;", "getUploadCompleteCommand", "uploadProgress", "", "getUploadProgress", "uploader", "Lcom/uploadcare/android/library/upload/Uploader;", "uploadingInBackgroundCommand", "Ljava/util/UUID;", "getUploadingInBackgroundCommand", "canlcelUpload", "", "error", "e", "getContext", "Landroid/content/Context;", "saveCookie", "cookie", "selectFile", "fileUrl", "signOut", "start", "source", "store", "uploadFileFromUrl", "file", "Lcom/uploadcare/android/widget/data/SelectedFile;", "widget_release"})
public final class UploadcareFilesViewModel
extends AndroidViewModel {
    @NotNull
    private final SingleLiveEvent<ProgressData> progressDialogCommand;
    @NotNull
    private final SingleLiveEvent<UploadcareApiException> closeWidgetCommand;
    @NotNull
    private final SingleLiveEvent<UploadcareFile> uploadCompleteCommand;
    @NotNull
    private final SingleLiveEvent<UUID> uploadingInBackgroundCommand;
    @NotNull
    private final SingleLiveEvent<String> showErrorCommand;
    @NotNull
    private final MutableLiveData<Integer> uploadProgress;
    @NotNull
    private final MutableLiveData<Boolean> isRoot;
    private SocialSource socialSource;
    private boolean storeUponUpload;
    private boolean cancelable;
    private boolean showProgress;
    private boolean backgroundUpload;
    private Uploader uploader;

    @NotNull
    public final SingleLiveEvent<ProgressData> getProgressDialogCommand() {
        return this.progressDialogCommand;
    }

    @NotNull
    public final SingleLiveEvent<UploadcareApiException> getCloseWidgetCommand() {
        return this.closeWidgetCommand;
    }

    @NotNull
    public final SingleLiveEvent<UploadcareFile> getUploadCompleteCommand() {
        return this.uploadCompleteCommand;
    }

    @NotNull
    public final SingleLiveEvent<UUID> getUploadingInBackgroundCommand() {
        return this.uploadingInBackgroundCommand;
    }

    @NotNull
    public final SingleLiveEvent<String> getShowErrorCommand() {
        return this.showErrorCommand;
    }

    @NotNull
    public final MutableLiveData<Integer> getUploadProgress() {
        return this.uploadProgress;
    }

    @NotNull
    public final MutableLiveData<Boolean> isRoot() {
        return this.isRoot;
    }

    public final void start(@NotNull SocialSource source, boolean store, boolean cancelable, boolean showProgress, boolean backgroundUpload) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.socialSource = source;
        this.storeUponUpload = store;
        this.cancelable = cancelable;
        this.showProgress = showProgress;
        this.backgroundUpload = backgroundUpload;
    }

    public final void selectFile(@NotNull String fileUrl) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
            SocialSource socialSource = this.socialSource;
            if (socialSource == null) break block0;
            SocialSource socialSource2 = socialSource;
            boolean bl = false;
            boolean bl2 = false;
            SocialSource source = socialSource2;
            boolean bl3 = false;
            this.progressDialogCommand.postValue(new ProgressData(true, this.getContext().getString(R.string.ucw_action_loading_image), this.cancelable, this.showProgress));
            UploadcareWidget.Companion.getInstance().getSocialApi$widget_release().selectFile(source.getCookie(this.getContext()), source.getUrls().getDone(), fileUrl).enqueue((Callback)new Callback<SelectedFile>(this, fileUrl){
                final /* synthetic */ UploadcareFilesViewModel this$0;
                final /* synthetic */ String $fileUrl$inlined;
                {
                    this.this$0 = uploadcareFilesViewModel;
                    this.$fileUrl$inlined = string2;
                }

                public void onFailure(@NotNull Call<SelectedFile> call, @NotNull Throwable t) {
                    Intrinsics.checkNotNullParameter(call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    UploadcareFilesViewModel.access$error(this.this$0, new UploadcareApiException(t));
                }

                public void onResponse(@NotNull Call<SelectedFile> call, @NotNull Response<SelectedFile> response) {
                    Intrinsics.checkNotNullParameter(call, (String)"call");
                    Intrinsics.checkNotNullParameter(response, (String)"response");
                    SelectedFile selectedFile = (SelectedFile)response.body();
                    if (selectedFile != null) {
                        SelectedFile selectedFile2 = selectedFile;
                        boolean bl = false;
                        boolean bl2 = false;
                        SelectedFile it = selectedFile2;
                        boolean bl3 = false;
                        SelectedFile selectedFile3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)selectedFile3, (String)"it");
                        UploadcareFilesViewModel.access$uploadFileFromUrl(this.this$0, selectedFile3);
                    } else {
                        UploadcareFilesViewModel.error$default(this.this$0, null, 1, null);
                    }
                }
            });
        }
    }

    public final void saveCookie(@NotNull String cookie) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
            SocialSource socialSource = this.socialSource;
            if (socialSource == null) break block0;
            socialSource.saveCookie(this.getContext(), cookie);
        }
    }

    public final void signOut() {
        block0: {
            SocialSource socialSource = this.socialSource;
            if (socialSource == null) break block0;
            SocialSource socialSource2 = socialSource;
            boolean bl = false;
            boolean bl2 = false;
            SocialSource source = socialSource2;
            boolean bl3 = false;
            this.progressDialogCommand.postValue(new ProgressData(true, this.getContext().getString(R.string.ucw_action_signout), false, false, 12, null));
            UploadcareWidget.Companion.getInstance().getSocialApi$widget_release().signOut(source.getCookie(this.getContext()), source.getUrls().getSession()).enqueue((Callback)new Callback<Object>(source, this){
                final /* synthetic */ SocialSource $source;
                final /* synthetic */ UploadcareFilesViewModel this$0;
                {
                    this.$source = $captured_local_variable$1;
                    this.this$0 = uploadcareFilesViewModel;
                }

                public void onFailure(@NotNull Call<Object> call, @NotNull Throwable t) {
                    Intrinsics.checkNotNullParameter(call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    this.this$0.getProgressDialogCommand().postValue(new ProgressData(false, null, false, false, 14, null));
                    this.this$0.getShowErrorCommand().postValue(UploadcareFilesViewModel.access$getContext(this.this$0).getString(R.string.ucw_error_auth));
                }

                public void onResponse(@NotNull Call<Object> call, @NotNull Response<Object> response) {
                    Intrinsics.checkNotNullParameter(call, (String)"call");
                    Intrinsics.checkNotNullParameter(response, (String)"response");
                    this.this$0.getProgressDialogCommand().postValue(new ProgressData(false, null, false, false, 14, null));
                    this.$source.deleteCookie(UploadcareFilesViewModel.access$getContext(this.this$0));
                    this.this$0.getCloseWidgetCommand().postValue(null);
                }
            });
        }
    }

    public final void canlcelUpload() {
        Uploader uploader = this.uploader;
        if (uploader != null) {
            uploader.cancel();
        }
        this.uploader = null;
        this.closeWidgetCommand.postValue(new UploadcareApiException("Canceled"));
    }

    /*
     * WARNING - void declaration
     */
    private final void uploadFileFromUrl(SelectedFile file) {
        if (this.backgroundUpload) {
            void pairs$iv;
            boolean $i$f$OneTimeWorkRequestBuilder22 = false;
            OneTimeWorkRequest.Builder requestBuilder = new OneTimeWorkRequest.Builder(FileUploadWorker.class);
            requestBuilder.addTag("uploadcare_worker");
            Pair[] $i$f$OneTimeWorkRequestBuilder22 = new Pair[]{TuplesKt.to((Object)"KEY_FILE_URL", (Object)file.getUrl()), TuplesKt.to((Object)"KEY_CANCELABLE", (Object)this.cancelable), TuplesKt.to((Object)"KEY_SHOW_PROGRESS", (Object)this.showProgress), TuplesKt.to((Object)"KEY_STORE", (Object)this.storeUponUpload)};
            OneTimeWorkRequest.Builder builder = requestBuilder;
            boolean $i$f$workDataOf = false;
            Data.Builder dataBuilder$iv = new Data.Builder();
            for (void pair$iv : pairs$iv) {
                dataBuilder$iv.put((String)pair$iv.getFirst(), pair$iv.getSecond());
            }
            Data data = dataBuilder$iv.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"dataBuilder.build()");
            Data data2 = data;
            builder.setInputData(data2);
            WorkRequest workRequest = requestBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"requestBuilder.build()");
            WorkRequest uploadWorkRequest = workRequest;
            WorkManager.getInstance((Context)this.getContext()).enqueue(uploadWorkRequest);
            this.uploadingInBackgroundCommand.postValue(uploadWorkRequest.getId());
        } else {
            Uploader uploader = this.uploader = (Uploader)new UrlUploader(UploadcareWidget.Companion.getInstance().getUploadcareClient(), file.getUrl()).store(this.storeUponUpload);
            Intrinsics.checkNotNull((Object)uploader);
            uploader.uploadAsync(new UploadFileCallback(this){
                final /* synthetic */ UploadcareFilesViewModel this$0;

                public void onFailure(@NotNull UploadcareApiException e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    UploadcareFilesViewModel.access$error(this.this$0, e);
                }

                public void onProgressUpdate(long bytesWritten, long contentLength, double progress) {
                    if (UploadcareFilesViewModel.access$getShowProgress$p(this.this$0)) {
                        this.this$0.getUploadProgress().setValue((Object)MathKt.roundToInt((double)(progress * (double)100)));
                    }
                }

                public void onSuccess(@NotNull UploadcareFile result) {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    this.this$0.getProgressDialogCommand().postValue(new ProgressData(false, null, false, false, 14, null));
                    this.this$0.getUploadCompleteCommand().postValue(result);
                    UploadcareFilesViewModel.access$setUploader$p(this.this$0, null);
                }
                {
                    this.this$0 = this$0;
                }
            });
        }
    }

    private final void error(UploadcareApiException e) {
        this.progressDialogCommand.postValue(new ProgressData(false, null, false, false, 14, null));
        this.closeWidgetCommand.postValue(e);
        this.uploader = null;
    }

    static /* synthetic */ void error$default(UploadcareFilesViewModel uploadcareFilesViewModel, UploadcareApiException uploadcareApiException, int n, Object object) {
        if ((n & 1) != 0) {
            uploadcareApiException = null;
        }
        uploadcareFilesViewModel.error(uploadcareApiException);
    }

    private final Context getContext() {
        Application application = this.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
        return (Context)application;
    }

    public UploadcareFilesViewModel(@NotNull Application application) {
        MutableLiveData $this$apply;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
        this.progressDialogCommand = new SingleLiveEvent();
        this.closeWidgetCommand = new SingleLiveEvent();
        this.uploadCompleteCommand = new SingleLiveEvent();
        this.uploadingInBackgroundCommand = new SingleLiveEvent();
        this.showErrorCommand = new SingleLiveEvent();
        MutableLiveData mutableLiveData = new MutableLiveData();
        boolean bl = false;
        boolean bl2 = false;
        MutableLiveData mutableLiveData2 = mutableLiveData;
        UploadcareFilesViewModel uploadcareFilesViewModel = this;
        boolean bl3 = false;
        $this$apply.setValue((Object)0);
        Unit unit = Unit.INSTANCE;
        uploadcareFilesViewModel.uploadProgress = mutableLiveData;
        mutableLiveData = new MutableLiveData();
        bl = false;
        bl2 = false;
        $this$apply = mutableLiveData;
        uploadcareFilesViewModel = this;
        boolean bl4 = false;
        $this$apply.setValue((Object)true);
        unit = Unit.INSTANCE;
        uploadcareFilesViewModel.isRoot = mutableLiveData;
    }

    public static final /* synthetic */ void access$error(UploadcareFilesViewModel $this, UploadcareApiException e) {
        $this.error(e);
    }

    public static final /* synthetic */ void access$uploadFileFromUrl(UploadcareFilesViewModel $this, SelectedFile file) {
        $this.uploadFileFromUrl(file);
    }

    public static final /* synthetic */ Context access$getContext(UploadcareFilesViewModel $this) {
        return $this.getContext();
    }

    public static final /* synthetic */ boolean access$getShowProgress$p(UploadcareFilesViewModel $this) {
        return $this.showProgress;
    }

    public static final /* synthetic */ void access$setShowProgress$p(UploadcareFilesViewModel $this, boolean bl) {
        $this.showProgress = bl;
    }

    public static final /* synthetic */ Uploader access$getUploader$p(UploadcareFilesViewModel $this) {
        return $this.uploader;
    }

    public static final /* synthetic */ void access$setUploader$p(UploadcareFilesViewModel $this, Uploader uploader) {
        $this.uploader = uploader;
    }
}

