/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.data.Chunk;
import java.util.ArrayList;
import java.util.List;

public class ToolbarSpinnerAdapter
extends ArrayAdapter<Chunk> {
    private List<Chunk> mItems = new ArrayList<Chunk>();
    private final LayoutInflater inflater;

    public ToolbarSpinnerAdapter(Context context, List<Chunk> objects) {
        super(context, R.layout.ucw_spinner_row, objects);
        this.mItems = objects;
        this.inflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public void clear() {
        super.clear();
        this.mItems.clear();
    }

    public void addItem(Chunk chunk) {
        this.mItems.add(chunk);
        this.notifyDataSetChanged();
    }

    public void addItems(List<Chunk> chunks) {
        this.mItems.addAll(chunks);
        this.notifyDataSetChanged();
    }

    public void updateItems(List<Chunk> chunks) {
        this.mItems = chunks;
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mItems.size();
    }

    public Chunk getItem(int position) {
        return this.mItems.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getDropDownView(int position, View view, ViewGroup parent) {
        if (view == null || !view.getTag().toString().equals("DROPDOWN")) {
            view = this.inflater.inflate(R.layout.ucw_spinner_row, parent, false);
            view.setTag((Object)"DROPDOWN");
        }
        TextView textView = (TextView)view.findViewById(R.id.ucw_spinner_title);
        textView.setText((CharSequence)this.getTitle(position));
        return view;
    }

    public View getView(int position, View view, ViewGroup parent) {
        if (view == null || !view.getTag().toString().equals("NON_DROPDOWN")) {
            view = this.inflater.inflate(R.layout.ucw_toolbar_spinner_item, parent, false);
            view.setTag((Object)"NON_DROPDOWN");
        }
        TextView textView = (TextView)view.findViewById(R.id.ucw_spinner_title);
        textView.setText((CharSequence)this.getTitle(position));
        return view;
    }

    private String getTitle(int position) {
        return position >= 0 && position < this.mItems.size() ? this.mItems.get((int)position).title : "";
    }
}

