/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.data;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.webkit.CookieManager;
import com.google.gson.annotations.SerializedName;
import com.uploadcare.android.widget.data.Chunk;
import java.util.ArrayList;
import java.util.List;

public class SocialSource
implements Parcelable {
    @SerializedName(value="root_chunks")
    public List<Chunk> rootChunks;
    public String name;
    public Urls urls;
    public static final Parcelable.Creator<SocialSource> CREATOR = new Parcelable.Creator<SocialSource>(){

        @NonNull
        public SocialSource createFromParcel(@NonNull Parcel in) {
            return new SocialSource(in);
        }

        @NonNull
        public SocialSource[] newArray(int size) {
            return new SocialSource[size];
        }
    };

    public void saveCookie(Context context, String cookie) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putString("UCW_PREF_" + this.name, cookie).commit();
    }

    public String getCookie(Context context) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context).getString("UCW_PREF_" + this.name, null);
    }

    public void deleteCookie(Context context) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().removeAllCookies(null);
        } else {
            CookieManager.getInstance().removeAllCookie();
        }
        preferences.edit().remove("UCW_PREF_" + this.name).commit();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeParcelable((Parcelable)this.urls, flags);
        dest.writeList(this.rootChunks);
    }

    public SocialSource() {
    }

    public SocialSource(@NonNull Parcel source) {
        this.name = source.readString();
        this.urls = (Urls)source.readParcelable(Urls.class.getClassLoader());
        this.rootChunks = new ArrayList<Chunk>();
        source.readList(this.rootChunks, Chunk.class.getClassLoader());
    }

    public String toString() {
        return "SocialSource{rootChunks=" + this.rootChunks + ", name='" + this.name + '\'' + ", urls=" + this.urls + '}';
    }

    public static class Urls
    implements Parcelable {
        @SerializedName(value="source_base")
        public String sourceBase;
        public String session;
        public String done;
        public static final Parcelable.Creator<Urls> CREATOR = new Parcelable.Creator<Urls>(){

            @NonNull
            public Urls createFromParcel(@NonNull Parcel in) {
                return new Urls(in);
            }

            @NonNull
            public Urls[] newArray(int size) {
                return new Urls[size];
            }
        };

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.sourceBase);
            dest.writeString(this.session);
            dest.writeString(this.done);
        }

        public Urls() {
        }

        public Urls(@NonNull Parcel source) {
            this.sourceBase = source.readString();
            this.session = source.readString();
            this.done = source.readString();
        }

        public String toString() {
            return "Urls{sourceBase='" + this.sourceBase + '\'' + ", session='" + this.session + '\'' + ", done='" + this.done + '\'' + '}';
        }
    }
}

