/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.utils;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;

public abstract class RecyclerViewOnScrollListener
extends RecyclerView.OnScrollListener {
    private int previousTotal = 0;
    private boolean loading = true;
    private int visibleThreshold = 20;
    int firstVisibleItem;
    int visibleItemCount;
    int totalItemCount;
    private GridLayoutManager mGridLayoutManager;
    private LinearLayoutManager mLinearLayoutManager;

    public RecyclerViewOnScrollListener(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof GridLayoutManager) {
            this.mGridLayoutManager = (GridLayoutManager)layoutManager;
        } else {
            this.mLinearLayoutManager = (LinearLayoutManager)layoutManager;
        }
    }

    public abstract void onLoadMore();

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        this.visibleItemCount = recyclerView.getChildCount();
        if (this.mGridLayoutManager != null) {
            this.totalItemCount = this.mGridLayoutManager.getItemCount();
            this.firstVisibleItem = this.mGridLayoutManager.findFirstVisibleItemPosition();
        } else {
            this.totalItemCount = this.mLinearLayoutManager.getItemCount();
            this.firstVisibleItem = this.mLinearLayoutManager.findFirstVisibleItemPosition();
        }
        if (this.loading && this.totalItemCount > this.previousTotal) {
            this.loading = false;
            this.previousTotal = this.totalItemCount;
        }
        if (!this.loading && this.totalItemCount - this.visibleItemCount <= this.firstVisibleItem + this.visibleThreshold) {
            this.onLoadMore();
            this.loading = true;
        }
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        super.onScrollStateChanged(recyclerView, newState);
    }

    public void clear() {
        this.previousTotal = 0;
        this.loading = false;
    }
}

