/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.android.widget.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.uploadcare.android.widget.R;
import com.uploadcare.android.widget.controller.UploadcareWidget;
import com.uploadcare.android.widget.data.Path;
import com.uploadcare.android.widget.data.Thing;
import com.uploadcare.android.widget.interfaces.ItemTapListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FilesAdapter<T extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<T> {
    List<Thing> mDataset = Collections.emptyList();
    final Context mContext;
    Path nextPath;
    ItemTapListener mItemTapListener;
    @UploadcareWidget.FileType
    String mFileType;

    public FilesAdapter(Context context, ItemTapListener listener, @UploadcareWidget.FileType String fileType) {
        this.mContext = context;
        this.mItemTapListener = listener;
        this.mDataset = new ArrayList<Thing>();
        this.mFileType = fileType;
    }

    public T onCreateViewHolder(ViewGroup parent, int viewType) {
        return null;
    }

    public void onBindViewHolder(T holder, int position) {
    }

    public int getItemCount() {
        return this.mDataset.size();
    }

    public String getNext() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.nextPath.chunks.size(); ++i) {
            if (i != this.nextPath.chunks.size() - 1) {
                stringBuilder.append(this.nextPath.chunks.get((int)i).pathChunk).append("/");
                continue;
            }
            stringBuilder.append(this.nextPath.chunks.get((int)i).pathChunk);
        }
        return stringBuilder.toString();
    }

    public void clear() {
        this.mDataset.clear();
        this.notifyDataSetChanged();
    }

    public boolean isEmpty() {
        return this.mDataset.isEmpty();
    }

    int getPlaceHolderResource(Thing thing) {
        int placeHolderResource = R.drawable.ucw_ic_file_grey_48dp;
        if (thing.objectType.equalsIgnoreCase("album") || thing.objectType.equalsIgnoreCase("folder")) {
            placeHolderResource = R.drawable.ucw_ic_folder_grey_48dp;
        } else if (thing.objectType.equalsIgnoreCase("photo") && (thing.thumbnail != null && thing.thumbnail.contains("http") || thing.action.action.equalsIgnoreCase("select_file") && thing.action.url.matches(".*((\\.jpg)|(\\.png)).*"))) {
            placeHolderResource = R.drawable.ucw_ic_photo_grey_48dp;
        }
        return placeHolderResource;
    }

    int getLinearPlaceHolderResource(Thing thing) {
        int placeHolderResource = R.drawable.ucw_ic_file_grey_24dp;
        if (thing.objectType.equalsIgnoreCase("album") || thing.objectType.equalsIgnoreCase("folder")) {
            placeHolderResource = R.drawable.ucw_ic_folder_grey_24dp;
        } else if (thing.objectType.equalsIgnoreCase("photo") && (thing.thumbnail != null && thing.thumbnail.contains("http") || thing.action.action.equalsIgnoreCase("select_file") && thing.action.url.matches(".*((\\.jpg)|(\\.png)).*"))) {
            placeHolderResource = R.drawable.ucw_ic_photo_grey_24dp;
        }
        return placeHolderResource;
    }

    public void addImages(List<Thing> nDataset, Path nextPath) {
        this.nextPath = nextPath;
        if (this.mFileType.equalsIgnoreCase("")) {
            this.mDataset.addAll(nDataset);
            this.notifyDataSetChanged();
        } else {
            for (Thing thing : nDataset) {
                if (thing.objectType.equalsIgnoreCase("album") || thing.objectType.equalsIgnoreCase("folder")) {
                    this.mDataset.add(thing);
                    this.notifyItemInserted(this.mDataset.size() - 1);
                    continue;
                }
                if (!thing.mimetype.startsWith(this.mFileType)) continue;
                this.mDataset.add(thing);
                this.notifyItemInserted(this.mDataset.size() - 1);
            }
        }
    }

    public void updateImages(List<Thing> nDataset, Path nextPath) {
        this.nextPath = nextPath;
        if (this.mFileType.equalsIgnoreCase("")) {
            this.mDataset = nDataset;
            this.notifyDataSetChanged();
        } else {
            for (Thing thing : nDataset) {
                if (thing.objectType.equalsIgnoreCase("album") || thing.objectType.equalsIgnoreCase("folder")) {
                    this.mDataset.add(thing);
                    this.notifyItemInserted(this.mDataset.size() - 1);
                    continue;
                }
                if (thing.mimetype == null || !thing.mimetype.startsWith(this.mFileType)) continue;
                this.mDataset.add(thing);
                this.notifyItemInserted(this.mDataset.size() - 1);
            }
        }
    }
}

